/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.internal;

import java.sql.DataTruncation;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import org.hibernate.JDBCException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.spi.AbstractSQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ConversionContext;

public class SQLExceptionTypeDelegate
extends AbstractSQLExceptionConversionDelegate {
    public SQLExceptionTypeDelegate(ConversionContext conversionContext) {
        super(conversionContext);
    }

    public JDBCException convert(SQLException sQLException, String string, String string2) {
        if (SQLClientInfoException.class.isInstance(sQLException) || SQLInvalidAuthorizationSpecException.class.isInstance(sQLException) || SQLNonTransientConnectionException.class.isInstance(sQLException) || SQLTransientConnectionException.class.isInstance(sQLException)) {
            return new JDBCConnectionException(string, sQLException, string2);
        }
        if (DataTruncation.class.isInstance(sQLException) || SQLDataException.class.isInstance(sQLException)) {
            throw new DataException(string, sQLException, string2);
        }
        if (SQLIntegrityConstraintViolationException.class.isInstance(sQLException)) {
            return new ConstraintViolationException(string, sQLException, string2, this.getConversionContext().getViolatedConstraintNameExtracter().extractConstraintName(sQLException));
        }
        if (SQLSyntaxErrorException.class.isInstance(sQLException)) {
            return new SQLGrammarException(string, sQLException, string2);
        }
        if (SQLTimeoutException.class.isInstance(sQLException)) {
            return new QueryTimeoutException(string, sQLException, string2);
        }
        if (SQLTransactionRollbackException.class.isInstance(sQLException)) {
            return new LockAcquisitionException(string, sQLException, string2);
        }
        return null;
    }
}

