/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.internal;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.JDBCException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.spi.AbstractSQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ConversionContext;
import org.hibernate.internal.util.JdbcExceptionHelper;

public class CacheSQLExceptionConversionDelegate
extends AbstractSQLExceptionConversionDelegate {
    private static final Set<String> DATA_CATEGORIES = new HashSet<String>();
    private static final Set<Integer> INTEGRITY_VIOLATION_CATEGORIES = new HashSet<Integer>();

    public CacheSQLExceptionConversionDelegate(ConversionContext conversionContext) {
        super(conversionContext);
    }

    public JDBCException convert(SQLException sQLException, String string, String string2) {
        String string3 = JdbcExceptionHelper.extractSqlStateClassCode(sQLException);
        if (string3 != null) {
            Integer n = JdbcExceptionHelper.extractErrorCode(sQLException);
            if (INTEGRITY_VIOLATION_CATEGORIES.contains(n)) {
                String string4 = this.getConversionContext().getViolatedConstraintNameExtracter().extractConstraintName(sQLException);
                return new ConstraintViolationException(string, sQLException, string2, string4);
            }
            if (DATA_CATEGORIES.contains(string3)) {
                return new DataException(string, sQLException, string2);
            }
        }
        return null;
    }

    static {
        DATA_CATEGORIES.add("22");
        DATA_CATEGORIES.add("21");
        DATA_CATEGORIES.add("02");
        INTEGRITY_VIOLATION_CATEGORIES.add(119);
        INTEGRITY_VIOLATION_CATEGORIES.add(120);
        INTEGRITY_VIOLATION_CATEGORIES.add(121);
        INTEGRITY_VIOLATION_CATEGORIES.add(122);
        INTEGRITY_VIOLATION_CATEGORIES.add(123);
        INTEGRITY_VIOLATION_CATEGORIES.add(124);
        INTEGRITY_VIOLATION_CATEGORIES.add(125);
        INTEGRITY_VIOLATION_CATEGORIES.add(127);
    }
}

