/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveNaturalIdEvent
extends AbstractEvent {
    public static final LockMode DEFAULT_LOCK_MODE = LockMode.NONE;
    private final EntityPersister entityPersister;
    private final Map<String, Object> naturalIdValues;
    private final Object[] orderedNaturalIdValues;
    private final LockOptions lockOptions;
    private Serializable entityId;

    public ResolveNaturalIdEvent(Map<String, Object> map, EntityPersister entityPersister, EventSource eventSource) {
        this(map, entityPersister, new LockOptions(), eventSource);
    }

    public ResolveNaturalIdEvent(Map<String, Object> map, EntityPersister entityPersister, LockOptions lockOptions, EventSource eventSource) {
        super(eventSource);
        if (entityPersister == null) {
            throw new IllegalArgumentException("EntityPersister is required for loading");
        }
        if (!entityPersister.hasNaturalIdentifier()) {
            throw new HibernateException("Entity did not define a natural-id");
        }
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("natural-id to load is required");
        }
        if (entityPersister.getNaturalIdentifierProperties().length != map.size()) {
            throw new HibernateException(String.format("Entity [%s] defines its natural-id with %d properties but only %d were specified", entityPersister.getEntityName(), entityPersister.getNaturalIdentifierProperties().length, map.size()));
        }
        if (lockOptions.getLockMode() == LockMode.WRITE) {
            throw new IllegalArgumentException("Invalid lock mode for loading");
        }
        if (lockOptions.getLockMode() == null) {
            lockOptions.setLockMode(DEFAULT_LOCK_MODE);
        }
        this.entityPersister = entityPersister;
        this.naturalIdValues = map;
        this.lockOptions = lockOptions;
        int[] nArray = entityPersister.getNaturalIdentifierProperties();
        this.orderedNaturalIdValues = new Object[nArray.length];
        int n = 0;
        for (int n2 : nArray) {
            String string = entityPersister.getPropertyNames()[n2];
            if (!map.containsKey(string)) {
                throw new HibernateException(String.format("No value specified for natural-id property %s#%s", this.getEntityName(), string));
            }
            this.orderedNaturalIdValues[n++] = map.get(entityPersister.getPropertyNames()[n2]);
        }
    }

    public Map<String, Object> getNaturalIdValues() {
        return Collections.unmodifiableMap(this.naturalIdValues);
    }

    public Object[] getOrderedNaturalIdValues() {
        return this.orderedNaturalIdValues;
    }

    public EntityPersister getEntityPersister() {
        return this.entityPersister;
    }

    public String getEntityName() {
        return this.getEntityPersister().getEntityName();
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public Serializable getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Serializable serializable) {
        this.entityId = serializable;
    }
}

