/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.spi;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;

public class RefreshEvent
extends AbstractEvent {
    private Object object;
    private String entityName;
    private LockOptions lockOptions = new LockOptions().setLockMode(LockMode.READ);

    public RefreshEvent(Object object, EventSource eventSource) {
        super(eventSource);
        if (object == null) {
            throw new IllegalArgumentException("Attempt to generate refresh event with null object");
        }
        this.object = object;
    }

    public RefreshEvent(String string, Object object, EventSource eventSource) {
        this(object, eventSource);
        this.entityName = string;
    }

    public RefreshEvent(Object object, LockMode lockMode, EventSource eventSource) {
        this(object, eventSource);
        if (lockMode == null) {
            throw new IllegalArgumentException("Attempt to generate refresh event with null lock mode");
        }
        this.lockOptions.setLockMode(lockMode);
    }

    public RefreshEvent(Object object, LockOptions lockOptions, EventSource eventSource) {
        this(object, eventSource);
        if (lockOptions == null) {
            throw new IllegalArgumentException("Attempt to generate refresh event with null lock request");
        }
        this.lockOptions = lockOptions;
    }

    public RefreshEvent(String string, Object object, LockOptions lockOptions, EventSource eventSource) {
        this(object, lockOptions, eventSource);
        this.entityName = string;
    }

    public Object getObject() {
        return this.object;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public LockMode getLockMode() {
        return this.lockOptions.getLockMode();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String string) {
        this.entityName = string;
    }

    public int getLockTimeout() {
        return this.lockOptions.getTimeOut();
    }

    public boolean getLockScope() {
        return this.lockOptions.getScope();
    }
}

