/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.service.internal;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.event.internal.DefaultAutoFlushEventListener;
import org.hibernate.event.internal.DefaultDeleteEventListener;
import org.hibernate.event.internal.DefaultDirtyCheckEventListener;
import org.hibernate.event.internal.DefaultEvictEventListener;
import org.hibernate.event.internal.DefaultFlushEntityEventListener;
import org.hibernate.event.internal.DefaultFlushEventListener;
import org.hibernate.event.internal.DefaultInitializeCollectionEventListener;
import org.hibernate.event.internal.DefaultLoadEventListener;
import org.hibernate.event.internal.DefaultLockEventListener;
import org.hibernate.event.internal.DefaultMergeEventListener;
import org.hibernate.event.internal.DefaultPersistEventListener;
import org.hibernate.event.internal.DefaultPersistOnFlushEventListener;
import org.hibernate.event.internal.DefaultPostLoadEventListener;
import org.hibernate.event.internal.DefaultPreLoadEventListener;
import org.hibernate.event.internal.DefaultRefreshEventListener;
import org.hibernate.event.internal.DefaultReplicateEventListener;
import org.hibernate.event.internal.DefaultResolveNaturalIdEventListener;
import org.hibernate.event.internal.DefaultSaveEventListener;
import org.hibernate.event.internal.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.internal.DefaultUpdateEventListener;
import org.hibernate.event.service.internal.EventListenerGroupImpl;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistrationException;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerRegistryImpl
implements EventListenerRegistry {
    private Map<Class, Object> listenerClassToInstanceMap = new HashMap<Class, Object>();
    private Map<EventType, EventListenerGroupImpl> registeredEventListenersMap = EventListenerRegistryImpl.prepareListenerMap();

    public <T> EventListenerGroupImpl<T> getEventListenerGroup(EventType<T> eventType) {
        EventListenerGroupImpl eventListenerGroupImpl = this.registeredEventListenersMap.get(eventType);
        if (eventListenerGroupImpl == null) {
            throw new HibernateException("Unable to find listeners for type [" + eventType.eventName() + "]");
        }
        return eventListenerGroupImpl;
    }

    @Override
    public void addDuplicationStrategy(DuplicationStrategy duplicationStrategy) {
        for (EventListenerGroupImpl eventListenerGroupImpl : this.registeredEventListenersMap.values()) {
            eventListenerGroupImpl.addDuplicationStrategy(duplicationStrategy);
        }
    }

    @Override
    public <T> void setListeners(EventType<T> eventType, Class<? extends T> ... classArray) {
        this.setListeners(eventType, this.resolveListenerInstances(eventType, classArray));
    }

    private <T> T[] resolveListenerInstances(EventType<T> eventType, Class<? extends T> ... classArray) {
        Object[] objectArray = (Object[])Array.newInstance(eventType.baseListenerInterface(), classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = this.resolveListenerInstance(classArray[i]);
        }
        return objectArray;
    }

    private <T> T resolveListenerInstance(Class<T> clazz) {
        Object object = this.listenerClassToInstanceMap.get(clazz);
        if (object == null) {
            object = this.instantiateListener(clazz);
            this.listenerClassToInstanceMap.put(clazz, object);
        }
        return (T)object;
    }

    private <T> T instantiateListener(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new EventListenerRegistrationException("Unable to instantiate specified event listener class: " + clazz.getName(), exception);
        }
    }

    @Override
    public <T> void setListeners(EventType<T> eventType, T ... TArray) {
        EventListenerGroup eventListenerGroup = this.getEventListenerGroup((EventType)eventType);
        ((EventListenerGroupImpl)eventListenerGroup).clear();
        if (TArray != null) {
            int n = TArray.length;
            for (int i = 0; i < n; ++i) {
                ((EventListenerGroupImpl)eventListenerGroup).appendListener(TArray[i]);
            }
        }
    }

    @Override
    public <T> void appendListeners(EventType<T> eventType, Class<? extends T> ... classArray) {
        this.appendListeners(eventType, this.resolveListenerInstances(eventType, classArray));
    }

    @Override
    public <T> void appendListeners(EventType<T> eventType, T ... TArray) {
        ((EventListenerGroupImpl)this.getEventListenerGroup((EventType)eventType)).appendListeners(TArray);
    }

    @Override
    public <T> void prependListeners(EventType<T> eventType, Class<? extends T> ... classArray) {
        this.prependListeners(eventType, this.resolveListenerInstances(eventType, classArray));
    }

    @Override
    public <T> void prependListeners(EventType<T> eventType, T ... TArray) {
        ((EventListenerGroupImpl)this.getEventListenerGroup((EventType)eventType)).prependListeners(TArray);
    }

    private static Map<EventType, EventListenerGroupImpl> prepareListenerMap() {
        HashMap<EventType, EventListenerGroupImpl> hashMap = new HashMap<EventType, EventListenerGroupImpl>();
        EventListenerRegistryImpl.prepareListeners(EventType.AUTO_FLUSH, new DefaultAutoFlushEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PERSIST, new DefaultPersistEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PERSIST_ONFLUSH, new DefaultPersistOnFlushEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.DELETE, new DefaultDeleteEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.DIRTY_CHECK, new DefaultDirtyCheckEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.EVICT, new DefaultEvictEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.FLUSH, new DefaultFlushEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.FLUSH_ENTITY, new DefaultFlushEntityEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.LOAD, new DefaultLoadEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.RESOLVE_NATURAL_ID, new DefaultResolveNaturalIdEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.INIT_COLLECTION, new DefaultInitializeCollectionEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.LOCK, new DefaultLockEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.MERGE, new DefaultMergeEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_COLLECTION_RECREATE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_COLLECTION_REMOVE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_COLLECTION_UPDATE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_DELETE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_INSERT, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_LOAD, new DefaultPreLoadEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.PRE_UPDATE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COLLECTION_RECREATE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COLLECTION_REMOVE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COLLECTION_UPDATE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COMMIT_DELETE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COMMIT_INSERT, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_COMMIT_UPDATE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_DELETE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_INSERT, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_LOAD, new DefaultPostLoadEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.POST_UPDATE, hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.UPDATE, new DefaultUpdateEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.REFRESH, new DefaultRefreshEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.REPLICATE, new DefaultReplicateEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.SAVE, new DefaultSaveEventListener(), hashMap);
        EventListenerRegistryImpl.prepareListeners(EventType.SAVE_UPDATE, new DefaultSaveOrUpdateEventListener(), hashMap);
        return Collections.unmodifiableMap(hashMap);
    }

    private static <T> void prepareListeners(EventType<T> eventType, Map<EventType, EventListenerGroupImpl> map) {
        EventListenerRegistryImpl.prepareListeners(eventType, null, map);
    }

    private static <T> void prepareListeners(EventType<T> eventType, T t, Map<EventType, EventListenerGroupImpl> map) {
        EventListenerGroupImpl<T> eventListenerGroupImpl = new EventListenerGroupImpl<T>(eventType);
        if (t != null) {
            eventListenerGroupImpl.appendListener(t);
        }
        map.put(eventType, eventListenerGroupImpl);
    }
}

