/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.service.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistrationException;
import org.hibernate.event.spi.EventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerGroupImpl<T>
implements EventListenerGroup<T> {
    private EventType<T> eventType;
    private final Set<DuplicationStrategy> duplicationStrategies = new LinkedHashSet<DuplicationStrategy>();
    private List<T> listeners;

    public EventListenerGroupImpl(EventType<T> eventType) {
        this.eventType = eventType;
        this.duplicationStrategies.add(new DuplicationStrategy(){

            public boolean areMatch(Object object, Object object2) {
                return object.getClass().equals(object2.getClass());
            }

            public DuplicationStrategy.Action getAction() {
                return DuplicationStrategy.Action.ERROR;
            }
        });
    }

    @Override
    public EventType<T> getEventType() {
        return this.eventType;
    }

    @Override
    public boolean isEmpty() {
        return this.count() <= 0;
    }

    @Override
    public int count() {
        return this.listeners == null ? 0 : this.listeners.size();
    }

    @Override
    public void clear() {
        if (this.duplicationStrategies != null) {
            this.duplicationStrategies.clear();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    @Override
    public void addDuplicationStrategy(DuplicationStrategy duplicationStrategy) {
        this.duplicationStrategies.add(duplicationStrategy);
    }

    @Override
    public Iterable<T> listeners() {
        return this.listeners == null ? Collections.emptyList() : this.listeners;
    }

    @Override
    public void appendListeners(T ... TArray) {
        for (T t : TArray) {
            this.appendListener(t);
        }
    }

    @Override
    public void appendListener(T t) {
        if (this.listenerShouldGetAdded(t)) {
            this.internalAppend(t);
        }
    }

    @Override
    public void prependListeners(T ... TArray) {
        for (T t : TArray) {
            this.prependListener(t);
        }
    }

    @Override
    public void prependListener(T t) {
        if (this.listenerShouldGetAdded(t)) {
            this.internalPrepend(t);
        }
    }

    private boolean listenerShouldGetAdded(T t) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<T>();
            return true;
        }
        boolean bl = true;
        block5: for (DuplicationStrategy duplicationStrategy : this.duplicationStrategies) {
            ListIterator<T> listIterator = this.listeners.listIterator();
            while (listIterator.hasNext()) {
                T t2 = listIterator.next();
                if (!duplicationStrategy.areMatch(t, t2)) continue;
                switch (duplicationStrategy.getAction()) {
                    case ERROR: {
                        throw new EventListenerRegistrationException("Duplicate event listener found");
                    }
                    case KEEP_ORIGINAL: {
                        bl = false;
                        break block5;
                    }
                    case REPLACE_ORIGINAL: {
                        listIterator.set(t);
                        bl = false;
                        break block5;
                    }
                }
            }
        }
        return bl;
    }

    private void internalPrepend(T t) {
        this.checkAgainstBaseInterface(t);
        this.listeners.add(0, t);
    }

    private void checkAgainstBaseInterface(T t) {
        if (!this.eventType.baseListenerInterface().isInstance(t)) {
            throw new EventListenerRegistrationException("Listener did not implement expected interface [" + this.eventType.baseListenerInterface().getName() + "]");
        }
    }

    private void internalAppend(T t) {
        this.checkAgainstBaseInterface(t);
        this.listeners.add(t);
    }
}

