/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.event.internal.ProxyVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class WrapVisitor
extends ProxyVisitor {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, WrapVisitor.class.getName());
    boolean substitute = false;

    boolean isSubstitutionRequired() {
        return this.substitute;
    }

    WrapVisitor(EventSource eventSource) {
        super(eventSource);
    }

    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        if (object != null && object instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)object;
            EventSource eventSource = this.getSession();
            if (persistentCollection.setCurrentSession(eventSource)) {
                this.reattachCollection(persistentCollection, collectionType);
            }
            return null;
        }
        return this.processArrayOrNewCollection(object, collectionType);
    }

    final Object processArrayOrNewCollection(Object object, CollectionType collectionType) throws HibernateException {
        EventSource eventSource = this.getSession();
        if (object == null) {
            return null;
        }
        CollectionPersister collectionPersister = eventSource.getFactory().getCollectionPersister(collectionType.getRole());
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        if (collectionType.hasHolder()) {
            if (object == CollectionType.UNFETCHED_COLLECTION) {
                return null;
            }
            PersistentCollection persistentCollection = persistenceContext.getCollectionHolder(object);
            if (persistentCollection == null) {
                persistentCollection = collectionType.wrap(eventSource, object);
                persistenceContext.addNewCollection(collectionPersister, persistentCollection);
                persistenceContext.addCollectionHolder(persistentCollection);
            }
            return null;
        }
        PersistentCollection persistentCollection = collectionType.wrap(eventSource, object);
        persistenceContext.addNewCollection(collectionPersister, persistentCollection);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Wrapped collection in role: {0}", (Object)collectionType.getRole());
        }
        return persistentCollection;
    }

    void processValue(int n, Object[] objectArray, Type[] typeArray) {
        Object object = this.processValue(objectArray[n], typeArray[n]);
        if (object != null) {
            this.substitute = true;
            objectArray[n] = object;
        }
    }

    Object processComponent(Object object, CompositeType compositeType) throws HibernateException {
        if (object != null) {
            Object[] objectArray = compositeType.getPropertyValues(object, this.getSession());
            Type[] typeArray = compositeType.getSubtypes();
            boolean bl = false;
            for (int i = 0; i < typeArray.length; ++i) {
                Object object2 = this.processValue(objectArray[i], typeArray[i]);
                if (object2 == null) continue;
                objectArray[i] = object2;
                bl = true;
            }
            if (bl) {
                compositeType.setPropertyValues(object, objectArray, EntityMode.POJO);
            }
        }
        return null;
    }

    void process(Object object, EntityPersister entityPersister) throws HibernateException {
        Object[] objectArray = entityPersister.getPropertyValues(object);
        Type[] typeArray = entityPersister.getPropertyTypes();
        this.processEntityPropertyValues(objectArray, typeArray);
        if (this.isSubstitutionRequired()) {
            entityPersister.setPropertyValues(object, objectArray);
        }
    }
}

