/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionRemoveAction;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.internal.ProxyVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class ReattachVisitor
extends ProxyVisitor {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ReattachVisitor.class.getName());
    private final Serializable ownerIdentifier;
    private final Object owner;

    public ReattachVisitor(EventSource eventSource, Serializable serializable, Object object) {
        super(eventSource);
        this.ownerIdentifier = serializable;
        this.owner = object;
    }

    final Serializable getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    final Object getOwner() {
        return this.owner;
    }

    Object processComponent(Object object, CompositeType compositeType) throws HibernateException {
        Type[] typeArray = compositeType.getSubtypes();
        if (object == null) {
            this.processValues(new Object[typeArray.length], typeArray);
        } else {
            super.processComponent(object, compositeType);
        }
        return null;
    }

    void removeCollection(CollectionPersister collectionPersister, Serializable serializable, EventSource eventSource) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Collection dereferenced while transient {0}", (Object)MessageHelper.collectionInfoString(collectionPersister, this.ownerIdentifier, eventSource.getFactory()));
        }
        eventSource.getActionQueue().addAction(new CollectionRemoveAction(this.owner, collectionPersister, serializable, false, (SessionImplementor)eventSource));
    }

    final Serializable extractCollectionKeyFromOwner(CollectionPersister collectionPersister) {
        if (collectionPersister.getCollectionType().useLHSPrimaryKey()) {
            return this.ownerIdentifier;
        }
        return (Serializable)collectionPersister.getOwnerEntityPersister().getPropertyValue(this.owner, collectionPersister.getCollectionType().getLHSPropertyName());
    }
}

