/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.event.internal.ReattachVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;

public class OnUpdateVisitor
extends ReattachVisitor {
    OnUpdateVisitor(EventSource eventSource, Serializable serializable, Object object) {
        super(eventSource, serializable, object);
    }

    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        if (object == CollectionType.UNFETCHED_COLLECTION) {
            return null;
        }
        EventSource eventSource = this.getSession();
        CollectionPersister collectionPersister = eventSource.getFactory().getCollectionPersister(collectionType.getRole());
        Serializable serializable = this.extractCollectionKeyFromOwner(collectionPersister);
        if (object != null && object instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)object;
            if (persistentCollection.setCurrentSession(eventSource)) {
                if (!OnUpdateVisitor.isOwnerUnchanged(persistentCollection, collectionPersister, serializable)) {
                    this.removeCollection(collectionPersister, serializable, eventSource);
                }
                this.reattachCollection(persistentCollection, collectionType);
            } else {
                this.removeCollection(collectionPersister, serializable, eventSource);
            }
        } else {
            this.removeCollection(collectionPersister, serializable, eventSource);
        }
        return null;
    }
}

