/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.event.internal.ReattachVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;

public class OnLockVisitor
extends ReattachVisitor {
    public OnLockVisitor(EventSource eventSource, Serializable serializable, Object object) {
        super(eventSource, serializable, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        EventSource eventSource = this.getSession();
        CollectionPersister collectionPersister = eventSource.getFactory().getCollectionPersister(collectionType.getRole());
        if (object == null) return null;
        if (!(object instanceof PersistentCollection)) throw new HibernateException("reassociated object has dirty collection reference (or an array)");
        PersistentCollection persistentCollection = (PersistentCollection)object;
        if (!persistentCollection.setCurrentSession(eventSource)) throw new HibernateException("reassociated object has dirty collection reference");
        if (!OnLockVisitor.isOwnerUnchanged(persistentCollection, collectionPersister, this.extractCollectionKeyFromOwner(collectionPersister))) throw new HibernateException("reassociated object has dirty collection reference");
        if (persistentCollection.isDirty()) {
            throw new HibernateException("reassociated object has dirty collection");
        }
        this.reattachCollection(persistentCollection, collectionType);
        return null;
    }
}

