/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.Collections;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.type.CollectionType;

public class FlushVisitor
extends AbstractVisitor {
    private Object owner;

    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        if (object == CollectionType.UNFETCHED_COLLECTION) {
            return null;
        }
        if (object != null) {
            PersistentCollection persistentCollection = collectionType.hasHolder() ? this.getSession().getPersistenceContext().getCollectionHolder(object) : (PersistentCollection)object;
            Collections.processReachableCollection(persistentCollection, collectionType, this.owner, this.getSession());
        }
        return null;
    }

    FlushVisitor(EventSource eventSource, Object object) {
        super(eventSource);
        this.owner = object;
    }
}

