/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.jboss.logging.Logger;

public class EvictVisitor
extends AbstractVisitor {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, EvictVisitor.class.getName());

    EvictVisitor(EventSource eventSource) {
        super(eventSource);
    }

    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        if (object != null) {
            this.evictCollection(object, collectionType);
        }
        return null;
    }

    public void evictCollection(Object object, CollectionType collectionType) {
        Object object2;
        if (collectionType.hasHolder()) {
            object2 = this.getSession().getPersistenceContext().removeCollectionHolder(object);
        } else if (object instanceof PersistentCollection) {
            object2 = object;
        } else {
            return;
        }
        PersistentCollection persistentCollection = (PersistentCollection)object2;
        if (persistentCollection.unsetSession(this.getSession())) {
            this.evictCollection(persistentCollection);
        }
    }

    private void evictCollection(PersistentCollection persistentCollection) {
        CollectionEntry collectionEntry = (CollectionEntry)this.getSession().getPersistenceContext().getCollectionEntries().remove(persistentCollection);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Evicting collection: %s", (Object)MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), persistentCollection, collectionEntry.getLoadedKey(), this.getSession()));
        }
        if (collectionEntry.getLoadedPersister() != null && collectionEntry.getLoadedPersister().getBatchSize() > 1) {
            this.getSession().getPersistenceContext().getBatchFetchQueue().removeBatchLoadableCollection(collectionEntry);
        }
        if (collectionEntry.getLoadedPersister() != null && collectionEntry.getLoadedKey() != null) {
            this.getSession().getPersistenceContext().getCollectionsByKey().remove(new CollectionKey(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey()));
        }
    }
}

