/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.event.spi.EventSource;
import org.hibernate.pretty.MessageHelper;

class EventCache
implements Map {
    private final EventSource session;
    private Map<Object, Object> entityToCopyMap = new IdentityHashMap<Object, Object>(10);
    private Map<Object, Object> copyToEntityMap = new IdentityHashMap<Object, Object>(10);
    private Map<Object, Boolean> entityToOperatedOnFlagMap = new IdentityHashMap<Object, Boolean>(10);

    EventCache(EventSource eventSource) {
        this.session = eventSource;
    }

    public void clear() {
        this.entityToCopyMap.clear();
        this.copyToEntityMap.clear();
        this.entityToOperatedOnFlagMap.clear();
    }

    public boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        return this.entityToCopyMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException("null copies are not supported by " + this.getClass().getName());
        }
        return this.copyToEntityMap.containsKey(object);
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this.entityToCopyMap.entrySet());
    }

    public Object get(Object object) {
        if (object == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        return this.entityToCopyMap.get(object);
    }

    public boolean isEmpty() {
        return this.entityToCopyMap.isEmpty();
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.entityToCopyMap.keySet());
    }

    public Object put(Object object, Object object2) {
        return this.put(object, object2, Boolean.FALSE);
    }

    Object put(Object object, Object object2, boolean bl) {
        if (object == null || object2 == null) {
            throw new NullPointerException("null entities and copies are not supported by " + this.getClass().getName());
        }
        Object object3 = this.entityToCopyMap.put(object, object2);
        Boolean bl2 = this.entityToOperatedOnFlagMap.put(object, bl);
        Object object4 = this.copyToEntityMap.put(object2, object);
        if (object3 == null) {
            if (object4 != null) {
                throw new IllegalStateException("Error occurred while storing entity " + this.printEntity(object) + ". An entity copy " + this.printEntity(object2) + " was already assigned to a different entity " + this.printEntity(object4) + ".");
            }
            if (bl2 != null) {
                throw new IllegalStateException("EventCache#entityToOperatedOnFlagMap contains an entity " + this.printEntity(object) + ", but EventCache#entityToCopyMap does not.");
            }
        } else {
            if (object3 != object2) {
                Object object5 = this.copyToEntityMap.remove(object3);
                if (object5 != object) {
                    throw new IllegalStateException("Error occurred while storing entity " + this.printEntity(object) + ". An unexpected entity " + this.printEntity(object5) + " was associated with the old entity copy " + this.printEntity(object3) + ".");
                }
                if (object4 != null) {
                    throw new IllegalStateException("Error occurred while storing entity " + this.printEntity(object) + ". A new entity copy " + this.printEntity(object2) + " is already associated with a different entity " + this.printEntity(object4) + ".");
                }
            } else if (object4 != object) {
                throw new IllegalStateException("An entity copy " + this.printEntity(object2) + " was associated with a different entity " + this.printEntity(object4) + " than provided " + this.printEntity(object) + ".");
            }
            if (bl2 == null) {
                throw new IllegalStateException("EventCache#entityToCopyMap contained an entity " + this.printEntity(object) + ", but EventCache#entityToOperatedOnFlagMap did not.");
            }
        }
        return object3;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    public Object remove(Object object) {
        Object object2;
        if (object == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        Boolean bl = this.entityToOperatedOnFlagMap.remove(object);
        Object object3 = this.entityToCopyMap.remove(object);
        Object object4 = object2 = object3 != null ? this.copyToEntityMap.remove(object3) : null;
        if (object3 == null) {
            if (bl != null) {
                throw new IllegalStateException("Removed entity " + this.printEntity(object) + " from EventCache#entityToOperatedOnFlagMap, but EventCache#entityToCopyMap did not contain the entity.");
            }
        } else {
            if (object2 == null) {
                throw new IllegalStateException("Removed entity " + this.printEntity(object) + " from EventCache#entityToCopyMap, but EventCache#copyToEntityMap did not contain the entity.");
            }
            if (bl == null) {
                throw new IllegalStateException("EventCache#entityToCopyMap contained an entity " + this.printEntity(object) + ", but EventCache#entityToOperatedOnFlagMap did not.");
            }
            if (object2 != object) {
                throw new IllegalStateException("An entity copy " + this.printEntity(object3) + " was associated with a different entity " + this.printEntity(object2) + " than provided " + this.printEntity(object) + ".");
            }
        }
        return object3;
    }

    public int size() {
        return this.entityToCopyMap.size();
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.entityToCopyMap.values());
    }

    public boolean isOperatedOn(Object object) {
        if (object == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        return this.entityToOperatedOnFlagMap.get(object);
    }

    void setOperatedOn(Object object, boolean bl) {
        if (object == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        if (!this.entityToOperatedOnFlagMap.containsKey(object) || !this.entityToCopyMap.containsKey(object)) {
            throw new AssertionFailure("called EventCache#setOperatedOn() for entity not found in EventCache");
        }
        this.entityToOperatedOnFlagMap.put(object, bl);
    }

    public Map invertMap() {
        return Collections.unmodifiableMap(this.copyToEntityMap);
    }

    private String printEntity(Object object) {
        if (this.session.getPersistenceContext().getEntry(object) != null) {
            return MessageHelper.infoString(this.session.getEntityName(object), this.session.getIdentifier(object));
        }
        return "[" + object + "]";
    }
}

