/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.type.CollectionType;

public class DirtyCollectionSearchVisitor
extends AbstractVisitor {
    private boolean dirty = false;
    private boolean[] propertyVersionability;

    DirtyCollectionSearchVisitor(EventSource eventSource, boolean[] blArray) {
        super(eventSource);
        this.propertyVersionability = blArray;
    }

    boolean wasDirtyCollectionFound() {
        return this.dirty;
    }

    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        if (object != null) {
            EventSource eventSource = this.getSession();
            PersistentCollection persistentCollection = collectionType.isArrayType() ? eventSource.getPersistenceContext().getCollectionHolder(object) : (PersistentCollection)object;
            if (persistentCollection.isDirty()) {
                this.dirty = true;
                return null;
            }
        }
        return null;
    }

    boolean includeEntityProperty(Object[] objectArray, int n) {
        return this.propertyVersionability[n] && super.includeEntityProperty(objectArray, n);
    }
}

