/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.OnUpdateVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.jboss.logging.Logger;

public class DefaultSaveOrUpdateEventListener
extends AbstractSaveEventListener
implements SaveOrUpdateEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultSaveOrUpdateEventListener.class.getName());

    public void onSaveOrUpdate(SaveOrUpdateEvent saveOrUpdateEvent) {
        EventSource eventSource = saveOrUpdateEvent.getSession();
        Object object = saveOrUpdateEvent.getObject();
        Serializable serializable = saveOrUpdateEvent.getRequestedId();
        if (serializable != null && object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().setIdentifier(serializable);
        }
        if (this.reassociateIfUninitializedProxy(object, eventSource)) {
            LOG.trace("Reassociated uninitialized proxy");
        } else {
            Object object2 = eventSource.getPersistenceContext().unproxyAndReassociate(object);
            saveOrUpdateEvent.setEntity(object2);
            saveOrUpdateEvent.setEntry(eventSource.getPersistenceContext().getEntry(object2));
            saveOrUpdateEvent.setResultId(this.performSaveOrUpdate(saveOrUpdateEvent));
        }
    }

    protected boolean reassociateIfUninitializedProxy(Object object, SessionImplementor sessionImplementor) {
        return sessionImplementor.getPersistenceContext().reassociateIfUninitializedProxy(object);
    }

    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent saveOrUpdateEvent) {
        AbstractSaveEventListener.EntityState entityState = this.getEntityState(saveOrUpdateEvent.getEntity(), saveOrUpdateEvent.getEntityName(), saveOrUpdateEvent.getEntry(), saveOrUpdateEvent.getSession());
        switch (entityState) {
            case DETACHED: {
                this.entityIsDetached(saveOrUpdateEvent);
                return null;
            }
            case PERSISTENT: {
                return this.entityIsPersistent(saveOrUpdateEvent);
            }
        }
        return this.entityIsTransient(saveOrUpdateEvent);
    }

    protected Serializable entityIsPersistent(SaveOrUpdateEvent saveOrUpdateEvent) throws HibernateException {
        Serializable serializable;
        EntityEntry entityEntry;
        boolean bl = LOG.isTraceEnabled();
        if (bl) {
            LOG.trace("Ignoring persistent instance");
        }
        if ((entityEntry = saveOrUpdateEvent.getEntry()) == null) {
            throw new AssertionFailure("entity was transient or detached");
        }
        if (entityEntry.getStatus() == Status.DELETED) {
            throw new AssertionFailure("entity was deleted");
        }
        SessionFactoryImplementor sessionFactoryImplementor = saveOrUpdateEvent.getSession().getFactory();
        Serializable serializable2 = saveOrUpdateEvent.getRequestedId();
        if (serializable2 == null) {
            serializable = entityEntry.getId();
        } else {
            boolean bl2;
            boolean bl3 = bl2 = !entityEntry.getPersister().getIdentifierType().isEqual(serializable2, entityEntry.getId(), sessionFactoryImplementor);
            if (bl2) {
                throw new PersistentObjectException("object passed to save() was already persistent: " + MessageHelper.infoString(entityEntry.getPersister(), serializable2, sessionFactoryImplementor));
            }
            serializable = serializable2;
        }
        if (bl) {
            LOG.tracev("Object already associated with session: {0}", (Object)MessageHelper.infoString(entityEntry.getPersister(), serializable, sessionFactoryImplementor));
        }
        return serializable;
    }

    protected Serializable entityIsTransient(SaveOrUpdateEvent saveOrUpdateEvent) {
        LOG.trace("Saving transient instance");
        EventSource eventSource = saveOrUpdateEvent.getSession();
        EntityEntry entityEntry = saveOrUpdateEvent.getEntry();
        if (entityEntry != null) {
            if (entityEntry.getStatus() == Status.DELETED) {
                eventSource.forceFlush(entityEntry);
            } else {
                throw new AssertionFailure("entity was persistent");
            }
        }
        Serializable serializable = this.saveWithGeneratedOrRequestedId(saveOrUpdateEvent);
        eventSource.getPersistenceContext().reassociateProxy(saveOrUpdateEvent.getObject(), serializable);
        return serializable;
    }

    protected Serializable saveWithGeneratedOrRequestedId(SaveOrUpdateEvent saveOrUpdateEvent) {
        return this.saveWithGeneratedId(saveOrUpdateEvent.getEntity(), saveOrUpdateEvent.getEntityName(), null, saveOrUpdateEvent.getSession(), true);
    }

    protected void entityIsDetached(SaveOrUpdateEvent saveOrUpdateEvent) {
        LOG.trace("Updating detached instance");
        if (saveOrUpdateEvent.getSession().getPersistenceContext().isEntryFor(saveOrUpdateEvent.getEntity())) {
            throw new AssertionFailure("entity was persistent");
        }
        Object object = saveOrUpdateEvent.getEntity();
        EntityPersister entityPersister = saveOrUpdateEvent.getSession().getEntityPersister(saveOrUpdateEvent.getEntityName(), object);
        saveOrUpdateEvent.setRequestedId(this.getUpdateId(object, entityPersister, saveOrUpdateEvent.getRequestedId(), saveOrUpdateEvent.getSession()));
        this.performUpdate(saveOrUpdateEvent, object, entityPersister);
    }

    protected Serializable getUpdateId(Object object, EntityPersister entityPersister, Serializable serializable, SessionImplementor sessionImplementor) {
        Serializable serializable2 = entityPersister.getIdentifier(object, sessionImplementor);
        if (serializable2 == null) {
            throw new TransientObjectException("The given object has a null identifier: " + entityPersister.getEntityName());
        }
        return serializable2;
    }

    protected void performUpdate(SaveOrUpdateEvent saveOrUpdateEvent, Object object, EntityPersister entityPersister) throws HibernateException {
        boolean bl = LOG.isTraceEnabled();
        if (bl && !entityPersister.isMutable()) {
            LOG.trace("Immutable instance passed to performUpdate()");
        }
        if (bl) {
            LOG.tracev("Updating {0}", (Object)MessageHelper.infoString(entityPersister, saveOrUpdateEvent.getRequestedId(), saveOrUpdateEvent.getSession().getFactory()));
        }
        EventSource eventSource = saveOrUpdateEvent.getSession();
        EntityKey entityKey = eventSource.generateEntityKey(saveOrUpdateEvent.getRequestedId(), entityPersister);
        eventSource.getPersistenceContext().checkUniqueness(entityKey, object);
        if (this.invokeUpdateLifecycle(object, entityPersister, eventSource)) {
            this.reassociate(saveOrUpdateEvent, saveOrUpdateEvent.getObject(), saveOrUpdateEvent.getRequestedId(), entityPersister);
            return;
        }
        new OnUpdateVisitor(eventSource, saveOrUpdateEvent.getRequestedId(), object).process(object, entityPersister);
        eventSource.getPersistenceContext().addEntity(object, entityPersister.isMutable() ? Status.MANAGED : Status.READ_ONLY, null, entityKey, entityPersister.getVersion(object), LockMode.NONE, true, entityPersister, false, true);
        entityPersister.afterReassociate(object, eventSource);
        if (bl) {
            LOG.tracev("Updating {0}", (Object)MessageHelper.infoString(entityPersister, saveOrUpdateEvent.getRequestedId(), eventSource.getFactory()));
        }
        this.cascadeOnUpdate(saveOrUpdateEvent, entityPersister, object);
    }

    protected boolean invokeUpdateLifecycle(Object object, EntityPersister entityPersister, EventSource eventSource) {
        if (entityPersister.implementsLifecycle()) {
            LOG.debug("Calling onUpdate()");
            if (((Lifecycle)object).onUpdate(eventSource)) {
                LOG.debug("Update vetoed by onUpdate()");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnUpdate(SaveOrUpdateEvent saveOrUpdateEvent, EntityPersister entityPersister, Object object) {
        EventSource eventSource = saveOrUpdateEvent.getSession();
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.SAVE_UPDATE, 0, eventSource).cascade(entityPersister, object);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.SAVE_UPDATE;
    }
}

