/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.Hibernate;
import org.hibernate.PersistentObjectException;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEvent;

public class DefaultSaveEventListener
extends DefaultSaveOrUpdateEventListener {
    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent saveOrUpdateEvent) {
        EntityEntry entityEntry = saveOrUpdateEvent.getSession().getPersistenceContext().getEntry(saveOrUpdateEvent.getEntity());
        if (entityEntry != null && entityEntry.getStatus() != Status.DELETED) {
            return this.entityIsPersistent(saveOrUpdateEvent);
        }
        return this.entityIsTransient(saveOrUpdateEvent);
    }

    protected Serializable saveWithGeneratedOrRequestedId(SaveOrUpdateEvent saveOrUpdateEvent) {
        if (saveOrUpdateEvent.getRequestedId() == null) {
            return super.saveWithGeneratedOrRequestedId(saveOrUpdateEvent);
        }
        return this.saveWithRequestedId(saveOrUpdateEvent.getEntity(), saveOrUpdateEvent.getRequestedId(), saveOrUpdateEvent.getEntityName(), null, saveOrUpdateEvent.getSession());
    }

    protected boolean reassociateIfUninitializedProxy(Object object, SessionImplementor sessionImplementor) {
        if (!Hibernate.isInitialized(object)) {
            throw new PersistentObjectException("uninitialized proxy passed to save()");
        }
        return false;
    }
}

