/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.internal.AbstractLockUpgradeEventListener;
import org.hibernate.event.spi.ResolveNaturalIdEvent;
import org.hibernate.event.spi.ResolveNaturalIdEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public class DefaultResolveNaturalIdEventListener
extends AbstractLockUpgradeEventListener
implements ResolveNaturalIdEventListener {
    public static final Object REMOVED_ENTITY_MARKER = new Object();
    public static final Object INCONSISTENT_RTN_CLASS_MARKER = new Object();
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultResolveNaturalIdEventListener.class.getName());

    public void onResolveNaturalId(ResolveNaturalIdEvent resolveNaturalIdEvent) throws HibernateException {
        Serializable serializable = this.resolveNaturalId(resolveNaturalIdEvent);
        resolveNaturalIdEvent.setEntityId(serializable);
    }

    protected Serializable resolveNaturalId(ResolveNaturalIdEvent resolveNaturalIdEvent) {
        Serializable serializable;
        EntityPersister entityPersister = resolveNaturalIdEvent.getEntityPersister();
        boolean bl = LOG.isTraceEnabled();
        if (bl) {
            LOG.tracev("Attempting to resolve: {0}", (Object)MessageHelper.infoString(entityPersister, resolveNaturalIdEvent.getNaturalIdValues(), resolveNaturalIdEvent.getSession().getFactory()));
        }
        if ((serializable = this.resolveFromCache(resolveNaturalIdEvent)) != null) {
            if (bl) {
                LOG.tracev("Resolved object in cache: {0}", (Object)MessageHelper.infoString(entityPersister, resolveNaturalIdEvent.getNaturalIdValues(), resolveNaturalIdEvent.getSession().getFactory()));
            }
            return serializable;
        }
        if (bl) {
            LOG.tracev("Object not resolved in any cache: {0}", (Object)MessageHelper.infoString(entityPersister, resolveNaturalIdEvent.getNaturalIdValues(), resolveNaturalIdEvent.getSession().getFactory()));
        }
        return this.loadFromDatasource(resolveNaturalIdEvent);
    }

    protected Serializable resolveFromCache(ResolveNaturalIdEvent resolveNaturalIdEvent) {
        return resolveNaturalIdEvent.getSession().getPersistenceContext().getNaturalIdHelper().findCachedNaturalIdResolution(resolveNaturalIdEvent.getEntityPersister(), resolveNaturalIdEvent.getOrderedNaturalIdValues());
    }

    protected Serializable loadFromDatasource(ResolveNaturalIdEvent resolveNaturalIdEvent) {
        SessionFactoryImplementor sessionFactoryImplementor = resolveNaturalIdEvent.getSession().getFactory();
        boolean bl = sessionFactoryImplementor.getStatistics().isStatisticsEnabled();
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        Serializable serializable = resolveNaturalIdEvent.getEntityPersister().loadEntityIdByNaturalId(resolveNaturalIdEvent.getOrderedNaturalIdValues(), resolveNaturalIdEvent.getLockOptions(), resolveNaturalIdEvent.getSession());
        if (bl) {
            NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy = resolveNaturalIdEvent.getEntityPersister().getNaturalIdCacheAccessStrategy();
            String string = naturalIdRegionAccessStrategy == null ? null : naturalIdRegionAccessStrategy.getRegion().getName();
            sessionFactoryImplementor.getStatisticsImplementor().naturalIdQueryExecuted(string, System.currentTimeMillis() - l);
        }
        if (serializable != null) {
            resolveNaturalIdEvent.getSession().getPersistenceContext().getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(resolveNaturalIdEvent.getEntityPersister(), serializable, resolveNaturalIdEvent.getOrderedNaturalIdValues());
        }
        return serializable;
    }
}

