/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ReplicationMode;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.OnReplicateVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.ReplicateEvent;
import org.hibernate.event.spi.ReplicateEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class DefaultReplicateEventListener
extends AbstractSaveEventListener
implements ReplicateEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultReplicateEventListener.class.getName());

    public void onReplicate(ReplicateEvent replicateEvent) {
        EventSource eventSource = replicateEvent.getSession();
        if (eventSource.getPersistenceContext().reassociateIfUninitializedProxy(replicateEvent.getObject())) {
            LOG.trace("Uninitialized proxy passed to replicate()");
            return;
        }
        Object object = eventSource.getPersistenceContext().unproxyAndReassociate(replicateEvent.getObject());
        if (eventSource.getPersistenceContext().isEntryFor(object)) {
            LOG.trace("Ignoring persistent instance passed to replicate()");
            return;
        }
        EntityPersister entityPersister = eventSource.getEntityPersister(replicateEvent.getEntityName(), object);
        Serializable serializable = entityPersister.getIdentifier(object, eventSource);
        if (serializable == null) {
            throw new TransientObjectException("instance with null id passed to replicate()");
        }
        ReplicationMode replicationMode = replicateEvent.getReplicationMode();
        Object object2 = replicationMode == ReplicationMode.EXCEPTION ? null : entityPersister.getCurrentVersion(serializable, eventSource);
        boolean bl = LOG.isTraceEnabled();
        if (object2 != null) {
            Object object3;
            boolean bl2;
            if (bl) {
                LOG.tracev("Found existing row for {0}", (Object)MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
            }
            if (bl2 = replicationMode.shouldOverwriteCurrentVersion(object, object3 = entityPersister.isVersioned() ? object2 : null, entityPersister.getVersion(object), entityPersister.getVersionType())) {
                this.performReplication(object, serializable, object3, entityPersister, replicationMode, eventSource);
            } else if (bl) {
                LOG.trace("No need to replicate");
            }
        } else {
            boolean bl3;
            if (bl) {
                LOG.tracev("No existing row, replicating new instance {0}", (Object)MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
            }
            EntityKey entityKey = (bl3 = entityPersister.isIdentifierAssignedByInsert()) ? null : eventSource.generateEntityKey(serializable, entityPersister);
            this.performSaveOrReplicate(object, entityKey, entityPersister, bl3, (Object)replicationMode, eventSource, true);
        }
    }

    protected boolean visitCollectionsBeforeSave(Object object, Serializable serializable, Object[] objectArray, Type[] typeArray, EventSource eventSource) {
        OnReplicateVisitor onReplicateVisitor = new OnReplicateVisitor(eventSource, serializable, object, false);
        onReplicateVisitor.processEntityPropertyValues(objectArray, typeArray);
        return super.visitCollectionsBeforeSave(object, serializable, objectArray, typeArray, eventSource);
    }

    protected boolean substituteValuesIfNecessary(Object object, Serializable serializable, Object[] objectArray, EntityPersister entityPersister, SessionImplementor sessionImplementor) {
        return false;
    }

    protected boolean isVersionIncrementDisabled() {
        return true;
    }

    private void performReplication(Object object, Serializable serializable, Object object2, EntityPersister entityPersister, ReplicationMode replicationMode, EventSource eventSource) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Replicating changes to {0}", (Object)MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
        }
        new OnReplicateVisitor(eventSource, serializable, object, true).process(object, entityPersister);
        eventSource.getPersistenceContext().addEntity(object, entityPersister.isMutable() ? Status.MANAGED : Status.READ_ONLY, null, eventSource.generateEntityKey(serializable, entityPersister), object2, LockMode.NONE, true, entityPersister, true, false);
        this.cascadeAfterReplicate(object, entityPersister, replicationMode, eventSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeAfterReplicate(Object object, EntityPersister entityPersister, ReplicationMode replicationMode, EventSource eventSource) {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.REPLICATE, 0, eventSource).cascade(entityPersister, object, (Object)replicationMode);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.REPLICATE;
    }
}

