/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.PersistentObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.internal.EvictVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class DefaultRefreshEventListener
implements RefreshEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultRefreshEventListener.class.getName());

    public void onRefresh(RefreshEvent refreshEvent) throws HibernateException {
        this.onRefresh(refreshEvent, new IdentityHashMap(10));
    }

    public void onRefresh(RefreshEvent refreshEvent, Map map) {
        Object object;
        Serializable serializable;
        EntityPersister entityPersister;
        boolean bl;
        EventSource eventSource = refreshEvent.getSession();
        boolean bl2 = bl = !eventSource.contains(refreshEvent.getObject());
        if (eventSource.getPersistenceContext().reassociateIfUninitializedProxy(refreshEvent.getObject())) {
            if (bl) {
                eventSource.setReadOnly(refreshEvent.getObject(), eventSource.isDefaultReadOnly());
            }
            return;
        }
        Object object2 = eventSource.getPersistenceContext().unproxyAndReassociate(refreshEvent.getObject());
        if (map.containsKey(object2)) {
            LOG.trace("Already refreshed");
            return;
        }
        EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object2);
        if (entityEntry == null) {
            entityPersister = eventSource.getEntityPersister(refreshEvent.getEntityName(), object2);
            serializable = entityPersister.getIdentifier(object2, refreshEvent.getSession());
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing transient {0}", (Object)MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
            }
            object = eventSource.generateEntityKey(serializable, entityPersister);
            if (eventSource.getPersistenceContext().getEntry(object) != null) {
                throw new PersistentObjectException("attempted to refresh transient instance when persistent instance was already associated with the Session: " + MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing ", (Object)MessageHelper.infoString(entityEntry.getPersister(), entityEntry.getId(), eventSource.getFactory()));
            }
            if (!entityEntry.isExistsInDatabase()) {
                throw new HibernateException("this instance does not yet exist as a row in the database");
            }
            entityPersister = entityEntry.getPersister();
            serializable = entityEntry.getId();
        }
        map.put(object2, object2);
        new Cascade(CascadingAction.REFRESH, 0, eventSource).cascade(entityPersister, object2, map);
        if (entityEntry != null) {
            object = eventSource.generateEntityKey(serializable, entityPersister);
            eventSource.getPersistenceContext().removeEntity((EntityKey)object);
            if (entityPersister.hasCollections()) {
                new EvictVisitor(eventSource).process(object2, entityPersister);
            }
        }
        if (entityPersister.hasCache()) {
            object = eventSource.generateCacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName());
            entityPersister.getCacheAccessStrategy().evict(object);
        }
        this.evictCachedCollections(entityPersister, serializable, eventSource.getFactory());
        object = eventSource.getLoadQueryInfluencers().getInternalFetchProfile();
        eventSource.getLoadQueryInfluencers().setInternalFetchProfile("refresh");
        Object object3 = entityPersister.load(serializable, object2, refreshEvent.getLockOptions(), (SessionImplementor)eventSource);
        if (object3 != null) {
            if (!entityPersister.isMutable()) {
                eventSource.setReadOnly(object3, true);
            } else {
                eventSource.setReadOnly(object3, entityEntry == null ? eventSource.isDefaultReadOnly() : entityEntry.isReadOnly());
            }
        }
        eventSource.getLoadQueryInfluencers().setInternalFetchProfile((String)object);
        UnresolvableObjectException.throwIfNull(object3, serializable, entityPersister.getEntityName());
    }

    private void evictCachedCollections(EntityPersister entityPersister, Serializable serializable, SessionFactoryImplementor sessionFactoryImplementor) {
        this.evictCachedCollections(entityPersister.getPropertyTypes(), serializable, sessionFactoryImplementor);
    }

    private void evictCachedCollections(Type[] typeArray, Serializable serializable, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        for (Type type : typeArray) {
            if (type.isCollectionType()) {
                sessionFactoryImplementor.getCache().evictCollection(((CollectionType)type).getRole(), serializable);
                continue;
            }
            if (!type.isComponentType()) continue;
            CompositeType compositeType = (CompositeType)type;
            this.evictCachedCollections(compositeType.getSubtypes(), serializable, sessionFactoryImplementor);
        }
    }
}

