/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.IdentityHashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.jboss.logging.Logger;

public class DefaultPersistEventListener
extends AbstractSaveEventListener
implements PersistEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultPersistEventListener.class.getName());

    protected CascadingAction getCascadeAction() {
        return CascadingAction.PERSIST;
    }

    protected Boolean getAssumedUnsaved() {
        return Boolean.TRUE;
    }

    public void onPersist(PersistEvent persistEvent) throws HibernateException {
        this.onPersist(persistEvent, new IdentityHashMap(10));
    }

    public void onPersist(PersistEvent persistEvent, Map map) throws HibernateException {
        EntityPersister entityPersister;
        Object object;
        Object object2;
        EventSource eventSource = persistEvent.getSession();
        Object object3 = persistEvent.getObject();
        if (object3 instanceof HibernateProxy) {
            object2 = ((HibernateProxy)object3).getHibernateLazyInitializer();
            if (object2.isUninitialized()) {
                if (object2.getSession() == eventSource) {
                    return;
                }
                throw new PersistentObjectException("uninitialized proxy passed to persist()");
            }
            object = object2.getImplementation();
        } else {
            object = object3;
        }
        if (persistEvent.getEntityName() != null) {
            object2 = persistEvent.getEntityName();
        } else {
            object2 = eventSource.bestGuessEntityName(object);
            persistEvent.setEntityName((String)object2);
        }
        EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
        AbstractSaveEventListener.EntityState entityState = this.getEntityState(object, (String)object2, entityEntry, eventSource);
        if (entityState == AbstractSaveEventListener.EntityState.DETACHED && ForeignGenerator.class.isInstance((entityPersister = eventSource.getFactory().getEntityPersister((String)object2)).getIdentifierGenerator())) {
            if (LOG.isDebugEnabled() && entityPersister.getIdentifier(object, eventSource) != null) {
                LOG.debug("Resetting entity id attribute to null for foreign generator");
            }
            entityPersister.setIdentifier(object, null, eventSource);
            entityState = this.getEntityState(object, (String)object2, entityEntry, eventSource);
        }
        switch (entityState) {
            case DETACHED: {
                throw new PersistentObjectException("detached entity passed to persist: " + this.getLoggableName(persistEvent.getEntityName(), object));
            }
            case PERSISTENT: {
                this.entityIsPersistent(persistEvent, map);
                break;
            }
            case TRANSIENT: {
                this.entityIsTransient(persistEvent, map);
                break;
            }
            case DELETED: {
                entityEntry.setStatus(Status.MANAGED);
                entityEntry.setDeletedState(null);
                persistEvent.getSession().getActionQueue().unScheduleDeletion(entityEntry, persistEvent.getObject());
                this.entityIsDeleted(persistEvent, map);
                break;
            }
            default: {
                throw new ObjectDeletedException("deleted entity passed to persist", null, this.getLoggableName(persistEvent.getEntityName(), object));
            }
        }
    }

    protected void entityIsPersistent(PersistEvent persistEvent, Map map) {
        LOG.trace("Ignoring persistent instance");
        EventSource eventSource = persistEvent.getSession();
        Object object = eventSource.getPersistenceContext().unproxy(persistEvent.getObject());
        EntityPersister entityPersister = eventSource.getEntityPersister(persistEvent.getEntityName(), object);
        if (map.put(object, object) == null) {
            this.justCascade(map, eventSource, object, entityPersister);
        }
    }

    private void justCascade(Map map, EventSource eventSource, Object object, EntityPersister entityPersister) {
        this.cascadeBeforeSave(eventSource, entityPersister, object, map);
        this.cascadeAfterSave(eventSource, entityPersister, object, map);
    }

    protected void entityIsTransient(PersistEvent persistEvent, Map map) {
        LOG.trace("Saving transient instance");
        EventSource eventSource = persistEvent.getSession();
        Object object = eventSource.getPersistenceContext().unproxy(persistEvent.getObject());
        if (map.put(object, object) == null) {
            this.saveWithGeneratedId(object, persistEvent.getEntityName(), map, eventSource, false);
        }
    }

    private void entityIsDeleted(PersistEvent persistEvent, Map map) {
        EventSource eventSource = persistEvent.getSession();
        Object object = eventSource.getPersistenceContext().unproxy(persistEvent.getObject());
        EntityPersister entityPersister = eventSource.getEntityPersister(persistEvent.getEntityName(), object);
        LOG.tracef("un-scheduling entity deletion [%s]", (Object)MessageHelper.infoString(entityPersister, entityPersister.getIdentifier(object, eventSource), eventSource.getFactory()));
        if (map.put(object, object) == null) {
            this.justCascade(map, eventSource, object, entityPersister);
        }
    }
}

