/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.EventCache;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public class DefaultMergeEventListener
extends AbstractSaveEventListener
implements MergeEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultMergeEventListener.class.getName());

    protected Map getMergeMap(Object object) {
        return ((EventCache)object).invertMap();
    }

    public void onMerge(MergeEvent mergeEvent) throws HibernateException {
        EventCache eventCache = new EventCache(mergeEvent.getSession());
        this.onMerge(mergeEvent, eventCache);
        eventCache.clear();
        eventCache = null;
    }

    public void onMerge(MergeEvent mergeEvent, Map map) throws HibernateException {
        EventCache eventCache = (EventCache)map;
        EventSource eventSource = mergeEvent.getSession();
        Object object = mergeEvent.getOriginal();
        if (object != null) {
            Object object2;
            Object object3;
            if (object instanceof HibernateProxy) {
                object3 = ((HibernateProxy)object).getHibernateLazyInitializer();
                if (object3.isUninitialized()) {
                    LOG.trace("Ignoring uninitialized proxy");
                    mergeEvent.setResult(eventSource.load(object3.getEntityName(), object3.getIdentifier()));
                    return;
                }
                object2 = object3.getImplementation();
            } else {
                object2 = object;
            }
            if (eventCache.containsKey(object2) && eventCache.isOperatedOn(object2)) {
                LOG.trace("Already in merge process");
                mergeEvent.setResult(object2);
            } else {
                EntityPersister entityPersister;
                Serializable serializable;
                if (eventCache.containsKey(object2)) {
                    LOG.trace("Already in copyCache; setting in merge process");
                    eventCache.setOperatedOn(object2, true);
                }
                mergeEvent.setEntity(object2);
                object3 = null;
                EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object2);
                if (entityEntry == null && (serializable = (entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object2)).getIdentifier(object2, eventSource)) != null) {
                    EntityKey entityKey = eventSource.generateEntityKey(serializable, entityPersister);
                    Object object4 = eventSource.getPersistenceContext().getEntity(entityKey);
                    entityEntry = eventSource.getPersistenceContext().getEntry(object4);
                    if (entityEntry != null) {
                        object3 = AbstractSaveEventListener.EntityState.DETACHED;
                    }
                }
                if (object3 == null) {
                    object3 = this.getEntityState(object2, mergeEvent.getEntityName(), entityEntry, eventSource);
                }
                switch (1.$SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState[((Enum)object3).ordinal()]) {
                    case 1: {
                        this.entityIsDetached(mergeEvent, eventCache);
                        break;
                    }
                    case 2: {
                        this.entityIsTransient(mergeEvent, eventCache);
                        break;
                    }
                    case 3: {
                        this.entityIsPersistent(mergeEvent, eventCache);
                        break;
                    }
                    default: {
                        throw new ObjectDeletedException("deleted instance passed to merge", null, this.getLoggableName(mergeEvent.getEntityName(), object2));
                    }
                }
            }
        }
    }

    protected void entityIsPersistent(MergeEvent mergeEvent, Map map) {
        LOG.trace("Ignoring persistent instance");
        Object object = mergeEvent.getEntity();
        EventSource eventSource = mergeEvent.getSession();
        EntityPersister entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object);
        ((EventCache)map).put(object, object, true);
        this.cascadeOnMerge(eventSource, entityPersister, object, map);
        this.copyValues(entityPersister, object, object, eventSource, map);
        mergeEvent.setResult(object);
    }

    protected void entityIsTransient(MergeEvent mergeEvent, Map map) {
        Serializable serializable;
        LOG.trace("Merging transient instance");
        Object object = mergeEvent.getEntity();
        EventSource eventSource = mergeEvent.getSession();
        String string = mergeEvent.getEntityName();
        EntityPersister entityPersister = eventSource.getEntityPersister(string, object);
        Serializable serializable2 = serializable = entityPersister.hasIdentifierProperty() ? entityPersister.getIdentifier(object, eventSource) : null;
        if (map.containsKey(object)) {
            entityPersister.setIdentifier(map.get(object), serializable, eventSource);
        } else {
            ((EventCache)map).put(object, eventSource.instantiate(entityPersister, serializable), true);
        }
        Object v = map.get(object);
        super.cascadeBeforeSave(eventSource, entityPersister, object, map);
        this.copyValues(entityPersister, object, v, eventSource, map, ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT);
        this.saveTransientEntity(v, string, mergeEvent.getRequestedId(), eventSource, map);
        super.cascadeAfterSave(eventSource, entityPersister, object, map);
        this.copyValues(entityPersister, object, v, eventSource, map, ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        mergeEvent.setResult(v);
    }

    private void saveTransientEntity(Object object, String string, Serializable serializable, EventSource eventSource, Map map) {
        if (serializable == null) {
            this.saveWithGeneratedId(object, string, map, eventSource, false);
        } else {
            this.saveWithRequestedId(object, serializable, string, map, eventSource);
        }
    }

    protected void entityIsDetached(MergeEvent mergeEvent, Map map) {
        Object object;
        LOG.trace("Merging detached instance");
        Object object2 = mergeEvent.getEntity();
        EventSource eventSource = mergeEvent.getSession();
        EntityPersister entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object2);
        String string = entityPersister.getEntityName();
        Serializable serializable = mergeEvent.getRequestedId();
        if (serializable == null) {
            serializable = entityPersister.getIdentifier(object2, eventSource);
        } else {
            object = entityPersister.getIdentifier(object2, eventSource);
            if (!entityPersister.getIdentifierType().isEqual(serializable, object, eventSource.getFactory())) {
                throw new HibernateException("merge requested with id not matching id of passed entity");
            }
        }
        object = eventSource.getFetchProfile();
        eventSource.setFetchProfile("merge");
        Serializable serializable2 = (Serializable)entityPersister.getIdentifierType().deepCopy(serializable, eventSource.getFactory());
        Object object3 = eventSource.get(string, serializable2);
        eventSource.setFetchProfile((String)object);
        if (object3 == null) {
            this.entityIsTransient(mergeEvent, map);
        } else {
            ((EventCache)map).put(object2, object3, true);
            Object object4 = eventSource.getPersistenceContext().unproxy(object3);
            if (object4 == object2) {
                throw new AssertionFailure("entity was not detached");
            }
            if (!eventSource.getEntityName(object4).equals(string)) {
                throw new WrongClassException("class of the given object did not match class of persistent copy", mergeEvent.getRequestedId(), string);
            }
            if (this.isVersionChanged(object2, eventSource, entityPersister, object4)) {
                if (eventSource.getFactory().getStatistics().isStatisticsEnabled()) {
                    eventSource.getFactory().getStatisticsImplementor().optimisticFailure(string);
                }
                throw new StaleObjectStateException(string, serializable);
            }
            this.cascadeOnMerge(eventSource, entityPersister, object2, map);
            this.copyValues(entityPersister, object2, object4, eventSource, map);
            this.markInterceptorDirty(object2, object4, entityPersister);
            mergeEvent.setResult(object3);
        }
    }

    private void markInterceptorDirty(Object object, Object object2, EntityPersister entityPersister) {
        FieldInterceptor fieldInterceptor;
        if (entityPersister.getInstrumentationMetadata().isInstrumented() && (fieldInterceptor = entityPersister.getInstrumentationMetadata().extractInterceptor(object2)) != null) {
            fieldInterceptor.dirty();
        }
    }

    private boolean isVersionChanged(Object object, EventSource eventSource, EntityPersister entityPersister, Object object2) {
        if (!entityPersister.isVersioned()) {
            return false;
        }
        boolean bl = !entityPersister.getVersionType().isSame(entityPersister.getVersion(object2), entityPersister.getVersion(object));
        return bl && this.existsInDatabase(object2, eventSource, entityPersister);
    }

    private boolean existsInDatabase(Object object, EventSource eventSource, EntityPersister entityPersister) {
        Serializable serializable;
        EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
        if (entityEntry == null && (serializable = entityPersister.getIdentifier(object, eventSource)) != null) {
            EntityKey entityKey = eventSource.generateEntityKey(serializable, entityPersister);
            Object object2 = eventSource.getPersistenceContext().getEntity(entityKey);
            entityEntry = eventSource.getPersistenceContext().getEntry(object2);
        }
        return entityEntry != null && entityEntry.isExistsInDatabase();
    }

    protected void copyValues(EntityPersister entityPersister, Object object, Object object2, SessionImplementor sessionImplementor, Map map) {
        Object[] objectArray = TypeHelper.replace(entityPersister.getPropertyValues(object), entityPersister.getPropertyValues(object2), entityPersister.getPropertyTypes(), sessionImplementor, object2, map);
        entityPersister.setPropertyValues(object2, objectArray);
    }

    protected void copyValues(EntityPersister entityPersister, Object object, Object object2, SessionImplementor sessionImplementor, Map map, ForeignKeyDirection foreignKeyDirection) {
        Object[] objectArray = foreignKeyDirection == ForeignKeyDirection.FOREIGN_KEY_TO_PARENT ? TypeHelper.replaceAssociations(entityPersister.getPropertyValues(object), entityPersister.getPropertyValues(object2), entityPersister.getPropertyTypes(), sessionImplementor, object2, map, foreignKeyDirection) : TypeHelper.replace(entityPersister.getPropertyValues(object), entityPersister.getPropertyValues(object2), entityPersister.getPropertyTypes(), sessionImplementor, object2, map, foreignKeyDirection);
        entityPersister.setPropertyValues(object2, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource eventSource, EntityPersister entityPersister, Object object, Map map) {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 0, eventSource).cascade(entityPersister, object, map);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.MERGE;
    }

    protected Boolean getAssumedUnsaved() {
        return Boolean.FALSE;
    }

    protected void cascadeAfterSave(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) throws HibernateException {
    }

    protected void cascadeBeforeSave(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) throws HibernateException {
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState;

        static {
            $SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState = new int[AbstractSaveEventListener.EntityState.values().length];
            try {
                1.$SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState[AbstractSaveEventListener.EntityState.DETACHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState[AbstractSaveEventListener.EntityState.TRANSIENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState[AbstractSaveEventListener.EntityState.PERSISTENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

