/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.event.internal.AbstractLockUpgradeEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LockEvent;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class DefaultLockEventListener
extends AbstractLockUpgradeEventListener
implements LockEventListener {
    public void onLock(LockEvent lockEvent) throws HibernateException {
        if (lockEvent.getObject() == null) {
            throw new NullPointerException("attempted to lock null");
        }
        if (lockEvent.getLockMode() == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for lock()");
        }
        EventSource eventSource = lockEvent.getSession();
        Object object = eventSource.getPersistenceContext().unproxyAndReassociate(lockEvent.getObject());
        EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
        if (entityEntry == null) {
            EntityPersister entityPersister = eventSource.getEntityPersister(lockEvent.getEntityName(), object);
            Serializable serializable = entityPersister.getIdentifier(object, eventSource);
            if (!ForeignKeys.isNotTransient(lockEvent.getEntityName(), object, Boolean.FALSE, eventSource)) {
                throw new TransientObjectException("cannot lock an unsaved transient instance: " + entityPersister.getEntityName());
            }
            entityEntry = this.reassociate(lockEvent, object, serializable, entityPersister);
            this.cascadeOnLock(lockEvent, entityPersister, object);
        }
        this.upgradeLock(object, entityEntry, lockEvent.getLockOptions(), lockEvent.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnLock(LockEvent lockEvent, EntityPersister entityPersister, Object object) {
        EventSource eventSource = lockEvent.getSession();
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.LOCK, 0, eventSource).cascade(entityPersister, object, lockEvent.getLockOptions());
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }
}

