/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cache.spi.entry.ReferenceCacheEntryImpl;
import org.hibernate.cache.spi.entry.StandardCacheEntryImpl;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractLockUpgradeEventListener;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLoadEventListener
extends AbstractLockUpgradeEventListener
implements LoadEventListener {
    public static final Object REMOVED_ENTITY_MARKER = new Object();
    public static final Object INCONSISTENT_RTN_CLASS_MARKER = new Object();
    public static final LockMode DEFAULT_LOCK_MODE = LockMode.NONE;
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultLoadEventListener.class.getName());

    @Override
    public void onLoad(LoadEvent loadEvent, LoadEventListener.LoadType loadType) throws HibernateException {
        EntityPersister entityPersister;
        EventSource eventSource = loadEvent.getSession();
        if (loadEvent.getInstanceToLoad() != null) {
            entityPersister = eventSource.getEntityPersister(null, loadEvent.getInstanceToLoad());
            loadEvent.setEntityClassName(loadEvent.getInstanceToLoad().getClass().getName());
        } else {
            entityPersister = eventSource.getFactory().getEntityPersister(loadEvent.getEntityClassName());
        }
        if (entityPersister == null) {
            throw new HibernateException("Unable to locate persister: " + loadEvent.getEntityClassName());
        }
        Class clazz = entityPersister.getIdentifierType().getReturnedClass();
        if (clazz != null && !clazz.isInstance(loadEvent.getEntityId())) {
            EntityType entityType;
            Type type;
            Type type2;
            EmbeddedComponentType embeddedComponentType;
            if (entityPersister.getEntityMetamodel().getIdentifierProperty().isEmbedded() && (embeddedComponentType = (EmbeddedComponentType)entityPersister.getEntityMetamodel().getIdentifierProperty().getType()).getSubtypes().length == 1 && (type2 = embeddedComponentType.getSubtypes()[0]).isEntityType() && (type = (entityType = (EntityType)type2).getIdentifierOrUniqueKeyType(eventSource.getFactory())).getReturnedClass().isInstance(loadEvent.getEntityId())) {
                this.loadByDerivedIdentitySimplePkValue(loadEvent, loadType, entityPersister, embeddedComponentType, eventSource.getFactory().getEntityPersister(entityType.getAssociatedEntityName()));
                return;
            }
            throw new TypeMismatchException("Provided id of the wrong type for class " + entityPersister.getEntityName() + ". Expected: " + clazz + ", got " + loadEvent.getEntityId().getClass());
        }
        EntityKey entityKey = eventSource.generateEntityKey(loadEvent.getEntityId(), entityPersister);
        try {
            if (loadType.isNakedEntityReturned()) {
                loadEvent.setResult(this.load(loadEvent, entityPersister, entityKey, loadType));
            } else if (loadEvent.getLockMode() == LockMode.NONE) {
                loadEvent.setResult(this.proxyOrLoad(loadEvent, entityPersister, entityKey, loadType));
            } else {
                loadEvent.setResult(this.lockAndLoad(loadEvent, entityPersister, entityKey, loadType, eventSource));
            }
        }
        catch (HibernateException hibernateException) {
            LOG.unableToLoadCommand(hibernateException);
            throw hibernateException;
        }
    }

    private void loadByDerivedIdentitySimplePkValue(LoadEvent loadEvent, LoadEventListener.LoadType loadType, EntityPersister entityPersister, EmbeddedComponentType embeddedComponentType, EntityPersister entityPersister2) {
        EntityKey entityKey = loadEvent.getSession().generateEntityKey(loadEvent.getEntityId(), entityPersister2);
        Object object = this.doLoad(loadEvent, entityPersister2, entityKey, loadType);
        Serializable serializable = (Serializable)embeddedComponentType.instantiate(object, loadEvent.getSession());
        embeddedComponentType.setPropertyValues(serializable, new Object[]{object}, entityPersister.getEntityMode());
        EntityKey entityKey2 = loadEvent.getSession().generateEntityKey(serializable, entityPersister);
        loadEvent.setEntityId(serializable);
        loadEvent.setResult(this.doLoad(loadEvent, entityPersister, entityKey2, loadType));
    }

    protected Object load(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType) {
        boolean bl;
        if (loadEvent.getInstanceToLoad() != null) {
            if (loadEvent.getSession().getPersistenceContext().getEntry(loadEvent.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session: " + MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory()));
            }
            entityPersister.setIdentifier(loadEvent.getInstanceToLoad(), loadEvent.getEntityId(), loadEvent.getSession());
        }
        Object object = this.doLoad(loadEvent, entityPersister, entityKey, loadType);
        boolean bl2 = bl = loadEvent.getInstanceToLoad() != null;
        if ((!loadType.isAllowNulls() || bl) && object == null) {
            loadEvent.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(loadEvent.getEntityClassName(), loadEvent.getEntityId());
        }
        if (bl && object != loadEvent.getInstanceToLoad()) {
            throw new NonUniqueObjectException(loadEvent.getEntityId(), loadEvent.getEntityClassName());
        }
        return object;
    }

    protected Object proxyOrLoad(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Loading entity: {0}", (Object)MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory()));
        }
        if (!entityPersister.hasProxy()) {
            return this.load(loadEvent, entityPersister, entityKey, loadType);
        }
        PersistenceContext persistenceContext = loadEvent.getSession().getPersistenceContext();
        Object object = persistenceContext.getProxy(entityKey);
        if (object != null) {
            return this.returnNarrowedProxy(loadEvent, entityPersister, entityKey, loadType, persistenceContext, object);
        }
        if (loadType.isAllowProxyCreation()) {
            return this.createProxyIfNecessary(loadEvent, entityPersister, entityKey, loadType, persistenceContext);
        }
        return this.load(loadEvent, entityPersister, entityKey, loadType);
    }

    private Object returnNarrowedProxy(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType, PersistenceContext persistenceContext, Object object) {
        LOG.trace("Entity proxy found in session cache");
        LazyInitializer lazyInitializer = ((HibernateProxy)object).getHibernateLazyInitializer();
        if (lazyInitializer.isUnwrap()) {
            return lazyInitializer.getImplementation();
        }
        Object object2 = null;
        if (!loadType.isAllowProxyCreation() && (object2 = this.load(loadEvent, entityPersister, entityKey, loadType)) == null) {
            loadEvent.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityPersister.getEntityName(), entityKey.getIdentifier());
        }
        return persistenceContext.narrowProxy(object, entityPersister, entityKey, object2);
    }

    private Object createProxyIfNecessary(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType, PersistenceContext persistenceContext) {
        Object object = persistenceContext.getEntity(entityKey);
        if (object != null) {
            EntityEntry entityEntry;
            Status status;
            LOG.trace("Entity found in session cache");
            if (loadType.isCheckDeleted() && ((status = (entityEntry = persistenceContext.getEntry(object)).getStatus()) == Status.DELETED || status == Status.GONE)) {
                return null;
            }
            return object;
        }
        LOG.trace("Creating new proxy for entity");
        Object object2 = entityPersister.createProxy(loadEvent.getEntityId(), loadEvent.getSession());
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
        persistenceContext.addProxy(entityKey, object2);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object lockAndLoad(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType, SessionImplementor sessionImplementor) {
        Object object;
        CacheKey cacheKey;
        SoftLock softLock = null;
        if (entityPersister.hasCache()) {
            cacheKey = sessionImplementor.generateCacheKey(loadEvent.getEntityId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName());
            softLock = entityPersister.getCacheAccessStrategy().lockItem(cacheKey, null);
        } else {
            cacheKey = null;
        }
        try {
            object = this.load(loadEvent, entityPersister, entityKey, loadType);
            if (!entityPersister.hasCache()) return loadEvent.getSession().getPersistenceContext().proxyFor(entityPersister, entityKey, object);
        }
        catch (Throwable throwable) {
            if (!entityPersister.hasCache()) throw throwable;
            entityPersister.getCacheAccessStrategy().unlockItem(cacheKey, softLock);
            throw throwable;
        }
        entityPersister.getCacheAccessStrategy().unlockItem(cacheKey, softLock);
        return loadEvent.getSession().getPersistenceContext().proxyFor(entityPersister, entityKey, object);
    }

    protected Object doLoad(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType) {
        Object object;
        boolean bl = LOG.isTraceEnabled();
        if (bl) {
            LOG.tracev("Attempting to resolve: {0}", (Object)MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory()));
        }
        if ((object = this.loadFromSessionCache(loadEvent, entityKey, loadType)) == REMOVED_ENTITY_MARKER) {
            LOG.debug("Load request found matching entity in context, but it is scheduled for removal; returning null");
            return null;
        }
        if (object == INCONSISTENT_RTN_CLASS_MARKER) {
            LOG.debug("Load request found matching entity in context, but the matched entity was of an inconsistent return type; returning null");
            return null;
        }
        if (object != null) {
            if (bl) {
                LOG.tracev("Resolved object in session cache: {0}", (Object)MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory()));
            }
            return object;
        }
        object = this.loadFromSecondLevelCache(loadEvent, entityPersister, loadType);
        if (object != null) {
            if (bl) {
                LOG.tracev("Resolved object in second-level cache: {0}", (Object)MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory()));
            }
        } else {
            if (bl) {
                LOG.tracev("Object not resolved in any cache: {0}", (Object)MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory()));
            }
            object = this.loadFromDatasource(loadEvent, entityPersister, entityKey, loadType);
        }
        if (object != null && entityPersister.hasNaturalIdentifier()) {
            loadEvent.getSession().getPersistenceContext().getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getPersistenceContext().getNaturalIdHelper().extractNaturalIdValues(object, entityPersister));
        }
        return object;
    }

    protected Object loadFromDatasource(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType) {
        EventSource eventSource = loadEvent.getSession();
        Object object = entityPersister.load(loadEvent.getEntityId(), loadEvent.getInstanceToLoad(), loadEvent.getLockOptions(), (SessionImplementor)eventSource);
        if (loadEvent.isAssociationFetch() && eventSource.getFactory().getStatistics().isStatisticsEnabled()) {
            eventSource.getFactory().getStatisticsImplementor().fetchEntity(loadEvent.getEntityClassName());
        }
        return object;
    }

    protected Object loadFromSessionCache(LoadEvent loadEvent, EntityKey entityKey, LoadEventListener.LoadType loadType) throws HibernateException {
        EventSource eventSource = loadEvent.getSession();
        Object object = eventSource.getEntityUsingInterceptor(entityKey);
        if (object != null) {
            Object object2;
            EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
            if (loadType.isCheckDeleted() && ((object2 = entityEntry.getStatus()) == Status.DELETED || object2 == Status.GONE)) {
                return REMOVED_ENTITY_MARKER;
            }
            if (loadType.isAllowNulls() && !(object2 = loadEvent.getSession().getFactory().getEntityPersister(entityKey.getEntityName())).isInstance(object)) {
                return INCONSISTENT_RTN_CLASS_MARKER;
            }
            this.upgradeLock(object, entityEntry, loadEvent.getLockOptions(), loadEvent.getSession());
        }
        return object;
    }

    protected Object loadFromSecondLevelCache(LoadEvent loadEvent, EntityPersister entityPersister, LoadEventListener.LoadType loadType) {
        boolean bl;
        EventSource eventSource = loadEvent.getSession();
        boolean bl2 = bl = entityPersister.hasCache() && eventSource.getCacheMode().isGetEnabled() && loadEvent.getLockMode().lessThan(LockMode.READ);
        if (!bl) {
            return null;
        }
        SessionFactoryImplementor sessionFactoryImplementor = eventSource.getFactory();
        CacheKey cacheKey = eventSource.generateCacheKey(loadEvent.getEntityId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName());
        Object object = entityPersister.getCacheAccessStrategy().get(cacheKey, eventSource.getTimestamp());
        if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
            if (object == null) {
                sessionFactoryImplementor.getStatisticsImplementor().secondLevelCacheMiss(entityPersister.getCacheAccessStrategy().getRegion().getName());
            } else {
                sessionFactoryImplementor.getStatisticsImplementor().secondLevelCacheHit(entityPersister.getCacheAccessStrategy().getRegion().getName());
            }
        }
        if (object == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)entityPersister.getCacheEntryStructure().destructure(object, sessionFactoryImplementor);
        return this.convertCacheEntryToEntity(cacheEntry, loadEvent.getEntityId(), entityPersister, loadEvent);
    }

    private Object convertCacheEntryToEntity(CacheEntry cacheEntry, Serializable serializable, EntityPersister entityPersister, LoadEvent loadEvent) {
        Object object;
        boolean bl;
        Object object2;
        Object[] objectArray;
        Object object3;
        Object object4;
        EventSource eventSource = loadEvent.getSession();
        SessionFactoryImplementor sessionFactoryImplementor = eventSource.getFactory();
        EntityPersister entityPersister2 = sessionFactoryImplementor.getEntityPersister(cacheEntry.getSubclass());
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Converting second-level cache entry [%s] into entity : %s", (Object)cacheEntry, (Object)MessageHelper.infoString(entityPersister, serializable, sessionFactoryImplementor));
        }
        if (cacheEntry.isReferenceEntry()) {
            object4 = loadEvent.getInstanceToLoad();
            if (object4 != null) {
                throw new HibernateException(String.format("Attempt to load entity [%s] from cache using provided object instance, but cache is storing references", MessageHelper.infoString(entityPersister, serializable, sessionFactoryImplementor)));
            }
            object3 = ((ReferenceCacheEntryImpl)cacheEntry).getReference();
            if (object3 == null) {
                throw new IllegalStateException("Reference cache entry contained null : " + MessageHelper.infoString(entityPersister, serializable, sessionFactoryImplementor));
            }
        } else {
            object4 = loadEvent.getInstanceToLoad();
            object3 = object4 == null ? eventSource.instantiate(entityPersister2, serializable) : object4;
        }
        object4 = eventSource.generateEntityKey(serializable, entityPersister2);
        TwoPhaseLoad.addUninitializedCachedEntity((EntityKey)object4, object3, entityPersister2, LockMode.NONE, cacheEntry.areLazyPropertiesUnfetched(), cacheEntry.getVersion(), eventSource);
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        if (cacheEntry.isReferenceEntry()) {
            objectArray = null;
            object2 = null;
            bl = true;
        } else {
            object = entityPersister2.getPropertyTypes();
            objectArray = ((StandardCacheEntryImpl)cacheEntry).assemble(object3, serializable, entityPersister2, eventSource.getInterceptor(), eventSource);
            if (((StandardCacheEntryImpl)cacheEntry).isDeepCopyNeeded()) {
                TypeHelper.deepCopy(objectArray, object, entityPersister2.getPropertyUpdateability(), objectArray, eventSource);
            }
            object2 = Versioning.getVersion(objectArray, entityPersister2);
            LOG.tracef("Cached Version : %s", object2);
            Iterator<PostLoadEventListener> iterator = persistenceContext.getProxy((EntityKey)object4);
            bl = iterator != null ? ((HibernateProxy)((Object)iterator)).getHibernateLazyInitializer().isReadOnly() : eventSource.isDefaultReadOnly();
        }
        persistenceContext.addEntry(object3, bl ? Status.READ_ONLY : Status.MANAGED, objectArray, null, serializable, object2, LockMode.NONE, true, entityPersister2, false, cacheEntry.areLazyPropertiesUnfetched());
        entityPersister2.afterInitialize(object3, cacheEntry.areLazyPropertiesUnfetched(), eventSource);
        persistenceContext.initializeNonLazyCollections();
        object = new PostLoadEvent(eventSource).setEntity(object3).setId(serializable).setPersister(entityPersister);
        for (PostLoadEventListener postLoadEventListener : this.postLoadEventListeners(eventSource)) {
            postLoadEventListener.onPostLoad((PostLoadEvent)object);
        }
        return object3;
    }

    private Object assembleCacheEntry(StandardCacheEntryImpl standardCacheEntryImpl, Serializable serializable, EntityPersister entityPersister, LoadEvent loadEvent) throws HibernateException {
        Object object;
        Object object2 = loadEvent.getInstanceToLoad();
        EventSource eventSource = loadEvent.getSession();
        SessionFactoryImplementor sessionFactoryImplementor = eventSource.getFactory();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Assembling entity from second-level cache: {0}", (Object)MessageHelper.infoString(entityPersister, serializable, sessionFactoryImplementor));
        }
        EntityPersister entityPersister2 = sessionFactoryImplementor.getEntityPersister(standardCacheEntryImpl.getSubclass());
        Object object3 = object2 == null ? eventSource.instantiate(entityPersister2, serializable) : object2;
        EntityKey entityKey = eventSource.generateEntityKey(serializable, entityPersister2);
        TwoPhaseLoad.addUninitializedCachedEntity(entityKey, object3, entityPersister2, LockMode.NONE, standardCacheEntryImpl.areLazyPropertiesUnfetched(), standardCacheEntryImpl.getVersion(), eventSource);
        Type[] typeArray = entityPersister2.getPropertyTypes();
        Object[] objectArray = standardCacheEntryImpl.assemble(object3, serializable, entityPersister2, eventSource.getInterceptor(), eventSource);
        TypeHelper.deepCopy(objectArray, typeArray, entityPersister2.getPropertyUpdateability(), objectArray, eventSource);
        Object object4 = Versioning.getVersion(objectArray, entityPersister2);
        LOG.tracev("Cached Version: {0}", object4);
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        boolean bl = eventSource.isDefaultReadOnly();
        if (entityPersister.isMutable()) {
            object = persistenceContext.getProxy(entityKey);
            if (object != null) {
                bl = ((HibernateProxy)object).getHibernateLazyInitializer().isReadOnly();
            }
        } else {
            bl = true;
        }
        persistenceContext.addEntry(object3, bl ? Status.READ_ONLY : Status.MANAGED, objectArray, null, serializable, object4, LockMode.NONE, true, entityPersister2, false, standardCacheEntryImpl.areLazyPropertiesUnfetched());
        entityPersister2.afterInitialize(object3, standardCacheEntryImpl.areLazyPropertiesUnfetched(), eventSource);
        persistenceContext.initializeNonLazyCollections();
        object = new PostLoadEvent(eventSource).setEntity(object3).setId(serializable).setPersister(entityPersister);
        for (PostLoadEventListener postLoadEventListener : this.postLoadEventListeners(eventSource)) {
            postLoadEventListener.onPostLoad((PostLoadEvent)object);
        }
        return object3;
    }

    private Iterable<PostLoadEventListener> postLoadEventListeners(EventSource eventSource) {
        return eventSource.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD).listeners();
    }
}

