/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.entry.CollectionCacheEntry;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public class DefaultInitializeCollectionEventListener
implements InitializeCollectionEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultInitializeCollectionEventListener.class.getName());

    public void onInitializeCollection(InitializeCollectionEvent initializeCollectionEvent) throws HibernateException {
        PersistentCollection persistentCollection = initializeCollectionEvent.getCollection();
        EventSource eventSource = initializeCollectionEvent.getSession();
        CollectionEntry collectionEntry = eventSource.getPersistenceContext().getCollectionEntry(persistentCollection);
        if (collectionEntry == null) {
            throw new HibernateException("collection was evicted");
        }
        if (!persistentCollection.wasInitialized()) {
            boolean bl;
            boolean bl2 = LOG.isTraceEnabled();
            if (bl2) {
                LOG.tracev("Initializing collection {0}", (Object)MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), persistentCollection, collectionEntry.getLoadedKey(), eventSource));
                LOG.trace("Checking second-level cache");
            }
            if (bl = this.initializeCollectionFromCache(collectionEntry.getLoadedKey(), collectionEntry.getLoadedPersister(), persistentCollection, eventSource)) {
                if (bl2) {
                    LOG.trace("Collection initialized from cache");
                }
            } else {
                if (bl2) {
                    LOG.trace("Collection not cached");
                }
                collectionEntry.getLoadedPersister().initialize(collectionEntry.getLoadedKey(), eventSource);
                if (bl2) {
                    LOG.trace("Collection initialized");
                }
                if (eventSource.getFactory().getStatistics().isStatisticsEnabled()) {
                    eventSource.getFactory().getStatisticsImplementor().fetchCollection(collectionEntry.getLoadedPersister().getRole());
                }
            }
        }
    }

    private boolean initializeCollectionFromCache(Serializable serializable, CollectionPersister collectionPersister, PersistentCollection persistentCollection, SessionImplementor sessionImplementor) {
        boolean bl;
        if (!sessionImplementor.getLoadQueryInfluencers().getEnabledFilters().isEmpty() && collectionPersister.isAffectedByEnabledFilters(sessionImplementor)) {
            LOG.trace("Disregarding cached version (if any) of collection due to enabled filters");
            return false;
        }
        boolean bl2 = bl = collectionPersister.hasCache() && sessionImplementor.getCacheMode().isGetEnabled();
        if (!bl) {
            return false;
        }
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        CacheKey cacheKey = sessionImplementor.generateCacheKey(serializable, collectionPersister.getKeyType(), collectionPersister.getRole());
        Object object = collectionPersister.getCacheAccessStrategy().get(cacheKey, sessionImplementor.getTimestamp());
        if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
            if (object == null) {
                sessionFactoryImplementor.getStatisticsImplementor().secondLevelCacheMiss(collectionPersister.getCacheAccessStrategy().getRegion().getName());
            } else {
                sessionFactoryImplementor.getStatisticsImplementor().secondLevelCacheHit(collectionPersister.getCacheAccessStrategy().getRegion().getName());
            }
        }
        if (object == null) {
            return false;
        }
        CollectionCacheEntry collectionCacheEntry = (CollectionCacheEntry)collectionPersister.getCacheEntryStructure().destructure(object, sessionFactoryImplementor);
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        collectionCacheEntry.assemble(persistentCollection, collectionPersister, persistenceContext.getCollectionOwner(serializable, collectionPersister));
        persistenceContext.getCollectionEntry(persistentCollection).postInitialize(persistentCollection);
        return true;
    }
}

