/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.event.internal.AbstractFlushingEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;

public class DefaultFlushEventListener
extends AbstractFlushingEventListener
implements FlushEventListener {
    public void onFlush(FlushEvent flushEvent) throws HibernateException {
        EventSource eventSource = flushEvent.getSession();
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        if (persistenceContext.getNumberOfManagedEntities() > 0 || persistenceContext.getCollectionEntries().size() > 0) {
            this.flushEverythingToExecutions(flushEvent);
            this.performExecutions(eventSource);
            this.postFlush(eventSource);
            if (eventSource.getFactory().getStatistics().isStatisticsEnabled()) {
                eventSource.getFactory().getStatisticsImplementor().flush();
            }
        }
    }
}

