/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.AssertionFailure;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.HibernateException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.DirtyCollectionSearchVisitor;
import org.hibernate.event.internal.FlushVisitor;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEntityEvent;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class DefaultFlushEntityEventListener
implements FlushEntityEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultFlushEntityEventListener.class.getName());

    public void checkId(Object object, EntityPersister entityPersister, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        if (serializable != null && serializable instanceof DelayedPostInsertIdentifier) {
            return;
        }
        if (entityPersister.canExtractIdOutOfEntity()) {
            Serializable serializable2 = entityPersister.getIdentifier(object, sessionImplementor);
            if (serializable == null) {
                throw new AssertionFailure("null id in " + entityPersister.getEntityName() + " entry (don't flush the Session after an exception occurs)");
            }
            if (!entityPersister.getIdentifierType().isEqual(serializable, serializable2, sessionImplementor.getFactory())) {
                throw new HibernateException("identifier of an instance of " + entityPersister.getEntityName() + " was altered from " + serializable + " to " + serializable2);
            }
        }
    }

    private void checkNaturalId(EntityPersister entityPersister, EntityEntry entityEntry, Object[] objectArray, Object[] objectArray2, SessionImplementor sessionImplementor) {
        if (entityPersister.hasNaturalIdentifier() && entityEntry.getStatus() != Status.READ_ONLY) {
            if (!entityPersister.getEntityMetamodel().hasImmutableNaturalId()) {
                return;
            }
            int[] nArray = entityPersister.getNaturalIdentifierProperties();
            Type[] typeArray = entityPersister.getPropertyTypes();
            boolean[] blArray = entityPersister.getPropertyUpdateability();
            Object[] objectArray3 = objectArray2 == null ? sessionImplementor.getPersistenceContext().getNaturalIdSnapshot(entityEntry.getId(), entityPersister) : sessionImplementor.getPersistenceContext().getNaturalIdHelper().extractNaturalIdValues(objectArray2, entityPersister);
            for (int i = 0; i < nArray.length; ++i) {
                Type type;
                int n = nArray[i];
                if (blArray[n] || (type = typeArray[n]).isEqual(objectArray[n], objectArray3[i])) continue;
                throw new HibernateException(String.format("An immutable natural identifier of entity %s was altered from %s to %s", entityPersister.getEntityName(), typeArray[n].toLoggableString(objectArray3[i], sessionImplementor.getFactory()), typeArray[n].toLoggableString(objectArray[n], sessionImplementor.getFactory())));
            }
        }
    }

    public void onFlushEntity(FlushEntityEvent flushEntityEvent) throws HibernateException {
        Object object = flushEntityEvent.getEntity();
        EntityEntry entityEntry = flushEntityEvent.getEntityEntry();
        EventSource eventSource = flushEntityEvent.getSession();
        EntityPersister entityPersister = entityEntry.getPersister();
        Status status = entityEntry.getStatus();
        Type[] typeArray = entityPersister.getPropertyTypes();
        boolean bl = entityEntry.requiresDirtyCheck(object);
        Object[] objectArray = this.getValues(object, entityEntry, bl, eventSource);
        flushEntityEvent.setPropertyValues(objectArray);
        boolean bl2 = this.wrapCollections(eventSource, entityPersister, typeArray, objectArray);
        if (this.isUpdateNecessary(flushEntityEvent, bl)) {
            boolean bl3 = bl2 = this.scheduleUpdate(flushEntityEvent) || bl2;
        }
        if (status != Status.DELETED) {
            if (bl2) {
                entityPersister.setPropertyValues(object, objectArray);
            }
            if (entityPersister.hasCollections()) {
                new FlushVisitor(eventSource, object).processEntityPropertyValues(objectArray, typeArray);
            }
        }
    }

    private Object[] getValues(Object object, EntityEntry entityEntry, boolean bl, SessionImplementor sessionImplementor) {
        Object[] objectArray;
        Object[] objectArray2 = entityEntry.getLoadedState();
        Status status = entityEntry.getStatus();
        EntityPersister entityPersister = entityEntry.getPersister();
        if (status == Status.DELETED) {
            objectArray = entityEntry.getDeletedState();
        } else if (!bl && objectArray2 != null) {
            objectArray = objectArray2;
        } else {
            this.checkId(object, entityPersister, entityEntry.getId(), sessionImplementor);
            objectArray = entityPersister.getPropertyValues(object);
            this.checkNaturalId(entityPersister, entityEntry, objectArray, objectArray2, sessionImplementor);
        }
        return objectArray;
    }

    private boolean wrapCollections(EventSource eventSource, EntityPersister entityPersister, Type[] typeArray, Object[] objectArray) {
        if (entityPersister.hasCollections()) {
            WrapVisitor wrapVisitor = new WrapVisitor(eventSource);
            wrapVisitor.processEntityPropertyValues(objectArray, typeArray);
            return wrapVisitor.isSubstitutionRequired();
        }
        return false;
    }

    private boolean isUpdateNecessary(FlushEntityEvent flushEntityEvent, boolean bl) {
        Status status = flushEntityEvent.getEntityEntry().getStatus();
        if (bl || status == Status.DELETED) {
            this.dirtyCheck(flushEntityEvent);
            if (this.isUpdateNecessary(flushEntityEvent)) {
                return true;
            }
            if (flushEntityEvent.getEntityEntry().getPersister().getInstrumentationMetadata().isInstrumented()) {
                flushEntityEvent.getEntityEntry().getPersister().getInstrumentationMetadata().extractInterceptor(flushEntityEvent.getEntity()).clearDirty();
            }
            flushEntityEvent.getSession().getFactory().getCustomEntityDirtinessStrategy().resetDirty(flushEntityEvent.getEntity(), flushEntityEvent.getEntityEntry().getPersister(), flushEntityEvent.getSession());
            return false;
        }
        return this.hasDirtyCollections(flushEntityEvent, flushEntityEvent.getEntityEntry().getPersister(), status);
    }

    private boolean scheduleUpdate(FlushEntityEvent flushEntityEvent) {
        EntityEntry entityEntry = flushEntityEvent.getEntityEntry();
        EventSource eventSource = flushEntityEvent.getSession();
        Object object = flushEntityEvent.getEntity();
        Status status = entityEntry.getStatus();
        EntityPersister entityPersister = entityEntry.getPersister();
        Object[] objectArray = flushEntityEvent.getPropertyValues();
        if (LOG.isTraceEnabled()) {
            if (status == Status.DELETED) {
                if (!entityPersister.isMutable()) {
                    LOG.tracev("Updating immutable, deleted entity: {0}", (Object)MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()));
                } else if (!entityEntry.isModifiableEntity()) {
                    LOG.tracev("Updating non-modifiable, deleted entity: {0}", (Object)MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()));
                } else {
                    LOG.tracev("Updating deleted entity: ", (Object)MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()));
                }
            } else {
                LOG.tracev("Updating entity: {0}", (Object)MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()));
            }
        }
        boolean bl = !entityEntry.isBeingReplicated() && this.handleInterception(flushEntityEvent);
        Object object2 = this.getNextVersion(flushEntityEvent);
        int[] nArray = flushEntityEvent.getDirtyProperties();
        if (flushEntityEvent.isDirtyCheckPossible() && nArray == null) {
            if (!bl && !flushEntityEvent.hasDirtyCollection()) {
                throw new AssertionFailure("dirty, but no dirty properties");
            }
            nArray = ArrayHelper.EMPTY_INT_ARRAY;
        }
        new Nullability(eventSource).checkNullability(objectArray, entityPersister, true);
        eventSource.getActionQueue().addAction(new EntityUpdateAction(entityEntry.getId(), objectArray, nArray, flushEntityEvent.hasDirtyCollection(), status == Status.DELETED && !entityEntry.isModifiableEntity() ? entityPersister.getPropertyValues(object) : entityEntry.getLoadedState(), entityEntry.getVersion(), object2, object, entityEntry.getRowId(), entityPersister, eventSource));
        return bl;
    }

    protected boolean handleInterception(FlushEntityEvent flushEntityEvent) {
        Object[] objectArray;
        EventSource eventSource = flushEntityEvent.getSession();
        EntityEntry entityEntry = flushEntityEvent.getEntityEntry();
        EntityPersister entityPersister = entityEntry.getPersister();
        Object object = flushEntityEvent.getEntity();
        boolean bl = this.invokeInterceptor(eventSource, object, entityEntry, objectArray = flushEntityEvent.getPropertyValues(), entityPersister);
        if (bl && flushEntityEvent.isDirtyCheckPossible() && !flushEntityEvent.isDirtyCheckHandledByInterceptor()) {
            int[] nArray = flushEntityEvent.hasDatabaseSnapshot() ? entityPersister.findModified(flushEntityEvent.getDatabaseSnapshot(), objectArray, object, eventSource) : entityPersister.findDirty(objectArray, entityEntry.getLoadedState(), object, eventSource);
            flushEntityEvent.setDirtyProperties(nArray);
        }
        return bl;
    }

    protected boolean invokeInterceptor(SessionImplementor sessionImplementor, Object object, EntityEntry entityEntry, Object[] objectArray, EntityPersister entityPersister) {
        return sessionImplementor.getInterceptor().onFlushDirty(object, entityEntry.getId(), objectArray, entityEntry.getLoadedState(), entityPersister.getPropertyNames(), entityPersister.getPropertyTypes());
    }

    private Object getNextVersion(FlushEntityEvent flushEntityEvent) throws HibernateException {
        EntityEntry entityEntry = flushEntityEvent.getEntityEntry();
        EntityPersister entityPersister = entityEntry.getPersister();
        if (entityPersister.isVersioned()) {
            Object[] objectArray = flushEntityEvent.getPropertyValues();
            if (entityEntry.isBeingReplicated()) {
                return Versioning.getVersion(objectArray, entityPersister);
            }
            int[] nArray = flushEntityEvent.getDirtyProperties();
            boolean bl = this.isVersionIncrementRequired(flushEntityEvent, entityEntry, entityPersister, nArray);
            Object object = bl ? Versioning.increment(entityEntry.getVersion(), entityPersister.getVersionType(), flushEntityEvent.getSession()) : entityEntry.getVersion();
            Versioning.setVersion(objectArray, object, entityPersister);
            return object;
        }
        return null;
    }

    private boolean isVersionIncrementRequired(FlushEntityEvent flushEntityEvent, EntityEntry entityEntry, EntityPersister entityPersister, int[] nArray) {
        boolean bl = entityEntry.getStatus() != Status.DELETED && (nArray == null || Versioning.isVersionIncrementRequired(nArray, flushEntityEvent.hasDirtyCollection(), entityPersister.getPropertyVersionability()));
        return bl;
    }

    protected final boolean isUpdateNecessary(FlushEntityEvent flushEntityEvent) throws HibernateException {
        EntityPersister entityPersister = flushEntityEvent.getEntityEntry().getPersister();
        Status status = flushEntityEvent.getEntityEntry().getStatus();
        if (!flushEntityEvent.isDirtyCheckPossible()) {
            return true;
        }
        int[] nArray = flushEntityEvent.getDirtyProperties();
        if (nArray != null && nArray.length != 0) {
            return true;
        }
        return this.hasDirtyCollections(flushEntityEvent, entityPersister, status);
    }

    private boolean hasDirtyCollections(FlushEntityEvent flushEntityEvent, EntityPersister entityPersister, Status status) {
        if (this.isCollectionDirtyCheckNecessary(entityPersister, status)) {
            DirtyCollectionSearchVisitor dirtyCollectionSearchVisitor = new DirtyCollectionSearchVisitor(flushEntityEvent.getSession(), entityPersister.getPropertyVersionability());
            dirtyCollectionSearchVisitor.processEntityPropertyValues(flushEntityEvent.getPropertyValues(), entityPersister.getPropertyTypes());
            boolean bl = dirtyCollectionSearchVisitor.wasDirtyCollectionFound();
            flushEntityEvent.setHasDirtyCollection(bl);
            return bl;
        }
        return false;
    }

    private boolean isCollectionDirtyCheckNecessary(EntityPersister entityPersister, Status status) {
        return (status == Status.MANAGED || status == Status.READ_ONLY) && entityPersister.isVersioned() && entityPersister.hasCollections();
    }

    protected void dirtyCheck(final FlushEntityEvent flushEntityEvent) throws HibernateException {
        boolean bl;
        boolean bl2;
        Object object = flushEntityEvent.getEntity();
        Object[] objectArray = flushEntityEvent.getPropertyValues();
        EventSource eventSource = flushEntityEvent.getSession();
        EntityEntry entityEntry = flushEntityEvent.getEntityEntry();
        EntityPersister entityPersister = entityEntry.getPersister();
        Serializable serializable = entityEntry.getId();
        Object[] objectArray2 = entityEntry.getLoadedState();
        int[] nArray = eventSource.getInterceptor().findDirty(object, serializable, objectArray, objectArray2, entityPersister.getPropertyNames(), entityPersister.getPropertyTypes());
        if (nArray == null) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class DirtyCheckContextImpl
            implements CustomEntityDirtinessStrategy.DirtyCheckContext {
                int[] found = null;

                DirtyCheckContextImpl() {
                }

                @Override
                public void doDirtyChecking(CustomEntityDirtinessStrategy.AttributeChecker attributeChecker) {
                    this.found = new DirtyCheckAttributeInfoImpl(flushEntityEvent).visitAttributes(attributeChecker);
                    if (this.found != null && this.found.length == 0) {
                        this.found = null;
                    }
                }
            }
            DirtyCheckContextImpl dirtyCheckContextImpl = new DirtyCheckContextImpl();
            eventSource.getFactory().getCustomEntityDirtinessStrategy().findDirty(object, entityPersister, eventSource, dirtyCheckContextImpl);
            nArray = dirtyCheckContextImpl.found;
        }
        flushEntityEvent.setDatabaseSnapshot(null);
        if (nArray == null) {
            bl2 = false;
            boolean bl3 = bl = objectArray2 == null;
            if (!bl) {
                nArray = entityPersister.findDirty(objectArray, objectArray2, object, eventSource);
            } else if (entityEntry.getStatus() == Status.DELETED && !flushEntityEvent.getEntityEntry().isModifiableEntity()) {
                if (objectArray != entityEntry.getDeletedState()) {
                    throw new IllegalStateException("Entity has status Status.DELETED but values != entry.getDeletedState");
                }
                Object[] objectArray3 = entityPersister.getPropertyValues(flushEntityEvent.getEntity());
                nArray = entityPersister.findDirty(entityEntry.getDeletedState(), objectArray3, object, eventSource);
                bl = false;
            } else {
                Object[] objectArray4 = this.getDatabaseSnapshot(eventSource, entityPersister, serializable);
                if (objectArray4 != null) {
                    nArray = entityPersister.findModified(objectArray4, objectArray, object, eventSource);
                    bl = false;
                    flushEntityEvent.setDatabaseSnapshot(objectArray4);
                }
            }
        } else {
            bl = false;
            bl2 = true;
        }
        this.logDirtyProperties(serializable, nArray, entityPersister);
        flushEntityEvent.setDirtyProperties(nArray);
        flushEntityEvent.setDirtyCheckHandledByInterceptor(bl2);
        flushEntityEvent.setDirtyCheckPossible(!bl);
    }

    private void logDirtyProperties(Serializable serializable, int[] nArray, EntityPersister entityPersister) {
        if (nArray != null && nArray.length > 0 && LOG.isTraceEnabled()) {
            String[] stringArray = entityPersister.getPropertyNames();
            String[] stringArray2 = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray2[i] = stringArray[nArray[i]];
            }
            LOG.tracev("Found dirty properties [{0}] : {1}", (Object)MessageHelper.infoString(entityPersister.getEntityName(), serializable), (Object)stringArray2);
        }
    }

    private Object[] getDatabaseSnapshot(SessionImplementor sessionImplementor, EntityPersister entityPersister, Serializable serializable) {
        if (entityPersister.isSelectBeforeUpdateRequired()) {
            Object[] objectArray = sessionImplementor.getPersistenceContext().getDatabaseSnapshot(serializable, entityPersister);
            if (objectArray == null) {
                if (sessionImplementor.getFactory().getStatistics().isStatisticsEnabled()) {
                    sessionImplementor.getFactory().getStatisticsImplementor().optimisticFailure(entityPersister.getEntityName());
                }
                throw new StaleObjectStateException(entityPersister.getEntityName(), serializable);
            }
            return objectArray;
        }
        EntityKey entityKey = sessionImplementor.generateEntityKey(serializable, entityPersister);
        return sessionImplementor.getPersistenceContext().getCachedDatabaseSnapshot(entityKey);
    }

    private class DirtyCheckAttributeInfoImpl
    implements CustomEntityDirtinessStrategy.AttributeInformation {
        private final FlushEntityEvent event;
        private final EntityPersister persister;
        private final int numberOfAttributes;
        private int index = 0;
        Object[] databaseSnapshot;

        private DirtyCheckAttributeInfoImpl(FlushEntityEvent flushEntityEvent) {
            this.event = flushEntityEvent;
            this.persister = flushEntityEvent.getEntityEntry().getPersister();
            this.numberOfAttributes = this.persister.getPropertyNames().length;
        }

        public EntityPersister getContainingPersister() {
            return this.persister;
        }

        public int getAttributeIndex() {
            return this.index;
        }

        public String getName() {
            return this.persister.getPropertyNames()[this.index];
        }

        public Type getType() {
            return this.persister.getPropertyTypes()[this.index];
        }

        public Object getCurrentValue() {
            return this.event.getPropertyValues()[this.index];
        }

        public Object getLoadedValue() {
            if (this.databaseSnapshot == null) {
                this.databaseSnapshot = DefaultFlushEntityEventListener.this.getDatabaseSnapshot(this.event.getSession(), this.persister, this.event.getEntityEntry().getId());
            }
            return this.databaseSnapshot[this.index];
        }

        public int[] visitAttributes(CustomEntityDirtinessStrategy.AttributeChecker attributeChecker) {
            this.databaseSnapshot = null;
            this.index = 0;
            int[] nArray = new int[this.numberOfAttributes];
            int n = 0;
            while (this.index < this.numberOfAttributes) {
                if (attributeChecker.isDirty(this)) {
                    nArray[n++] = this.index;
                }
                ++this.index;
            }
            return Arrays.copyOf(nArray, n);
        }
    }
}

