/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.event.internal.EvictVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EvictEvent;
import org.hibernate.event.spi.EvictEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.jboss.logging.Logger;

public class DefaultEvictEventListener
implements EvictEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultEvictEventListener.class.getName());

    public void onEvict(EvictEvent evictEvent) throws HibernateException {
        Object object = evictEvent.getObject();
        if (object == null) {
            throw new NullPointerException("null passed to Session.evict()");
        }
        EventSource eventSource = evictEvent.getSession();
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        if (object instanceof HibernateProxy) {
            Object object2;
            LazyInitializer lazyInitializer = ((HibernateProxy)object).getHibernateLazyInitializer();
            Serializable serializable = lazyInitializer.getIdentifier();
            if (serializable == null) {
                throw new IllegalArgumentException("Could not determine identifier of proxy passed to evict()");
            }
            EntityPersister entityPersister = eventSource.getFactory().getEntityPersister(lazyInitializer.getEntityName());
            EntityKey entityKey = eventSource.generateEntityKey(serializable, entityPersister);
            persistenceContext.removeProxy(entityKey);
            if (!lazyInitializer.isUninitialized() && (object2 = persistenceContext.removeEntity(entityKey)) != null) {
                EntityEntry entityEntry = persistenceContext.removeEntry(object2);
                this.doEvict(object2, entityKey, entityEntry.getPersister(), evictEvent.getSession());
            }
            lazyInitializer.unsetSession();
        } else {
            EntityEntry entityEntry = persistenceContext.removeEntry(object);
            if (entityEntry != null) {
                persistenceContext.removeEntity(entityEntry.getEntityKey());
                this.doEvict(object, entityEntry.getEntityKey(), entityEntry.getPersister(), eventSource);
            } else {
                EntityPersister entityPersister = null;
                String string = persistenceContext.getSession().guessEntityName(object);
                if (string != null) {
                    try {
                        entityPersister = persistenceContext.getSession().getFactory().getEntityPersister(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (entityPersister == null) {
                    throw new IllegalArgumentException("Non-entity object instance passed to evict : " + object);
                }
            }
        }
    }

    protected void doEvict(Object object, EntityKey entityKey, EntityPersister entityPersister, EventSource eventSource) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Evicting {0}", (Object)MessageHelper.infoString(entityPersister));
        }
        if (entityPersister.hasNaturalIdentifier()) {
            eventSource.getPersistenceContext().getNaturalIdHelper().handleEviction(object, entityPersister, entityKey.getIdentifier());
        }
        if (entityPersister.hasCollections()) {
            new EvictVisitor(eventSource).process(object, entityPersister);
        }
        new Cascade(CascadingAction.EVICT, 0, eventSource).cascade(entityPersister, object);
    }
}

