/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.event.internal.AbstractFlushingEventListener;
import org.hibernate.event.spi.DirtyCheckEvent;
import org.hibernate.event.spi.DirtyCheckEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class DefaultDirtyCheckEventListener
extends AbstractFlushingEventListener
implements DirtyCheckEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultDirtyCheckEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDirtyCheck(DirtyCheckEvent dirtyCheckEvent) throws HibernateException {
        int n = dirtyCheckEvent.getSession().getActionQueue().numberOfCollectionRemovals();
        try {
            this.flushEverythingToExecutions(dirtyCheckEvent);
            boolean bl = dirtyCheckEvent.getSession().getActionQueue().hasAnyQueuedActions();
            if (bl) {
                LOG.debug("Session dirty");
            } else {
                LOG.debug("Session not dirty");
            }
            dirtyCheckEvent.setDirty(bl);
        }
        finally {
            dirtyCheckEvent.getSession().getActionQueue().clearFromFlushNeededCheck(n);
        }
    }
}

