/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.event.internal.AbstractFlushingEventListener;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class DefaultAutoFlushEventListener
extends AbstractFlushingEventListener
implements AutoFlushEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultAutoFlushEventListener.class.getName());

    public void onAutoFlush(AutoFlushEvent autoFlushEvent) throws HibernateException {
        EventSource eventSource = autoFlushEvent.getSession();
        if (this.flushMightBeNeeded(eventSource)) {
            int n = eventSource.getActionQueue().numberOfCollectionRemovals();
            this.flushEverythingToExecutions(autoFlushEvent);
            if (this.flushIsReallyNeeded(autoFlushEvent, eventSource)) {
                LOG.trace("Need to execute flush");
                this.performExecutions(eventSource);
                this.postFlush(eventSource);
                if (eventSource.getFactory().getStatistics().isStatisticsEnabled()) {
                    eventSource.getFactory().getStatisticsImplementor().flush();
                }
            } else {
                LOG.trace("Don't need to execute flush");
                eventSource.getActionQueue().clearFromFlushNeededCheck(n);
            }
            autoFlushEvent.setFlushRequired(this.flushIsReallyNeeded(autoFlushEvent, eventSource));
        }
    }

    private boolean flushIsReallyNeeded(AutoFlushEvent autoFlushEvent, EventSource eventSource) {
        return eventSource.getActionQueue().areTablesToBeUpdated(autoFlushEvent.getQuerySpaces()) || eventSource.getFlushMode() == FlushMode.ALWAYS;
    }

    private boolean flushMightBeNeeded(EventSource eventSource) {
        return !eventSource.getFlushMode().lessThan(FlushMode.AUTO) && eventSource.getDontFlushFromFind() == 0 && (eventSource.getPersistenceContext().getNumberOfManagedEntities() > 0 || eventSource.getPersistenceContext().getCollectionEntries().size() > 0);
    }
}

