/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public abstract class AbstractVisitor {
    private final EventSource session;

    AbstractVisitor(EventSource eventSource) {
        this.session = eventSource;
    }

    void processValues(Object[] objectArray, Type[] typeArray) throws HibernateException {
        for (int i = 0; i < typeArray.length; ++i) {
            if (!this.includeProperty(objectArray, i)) continue;
            this.processValue(i, objectArray, typeArray);
        }
    }

    public void processEntityPropertyValues(Object[] objectArray, Type[] typeArray) throws HibernateException {
        for (int i = 0; i < typeArray.length; ++i) {
            if (!this.includeEntityProperty(objectArray, i)) continue;
            this.processValue(i, objectArray, typeArray);
        }
    }

    void processValue(int n, Object[] objectArray, Type[] typeArray) {
        this.processValue(objectArray[n], typeArray[n]);
    }

    boolean includeEntityProperty(Object[] objectArray, int n) {
        return this.includeProperty(objectArray, n);
    }

    boolean includeProperty(Object[] objectArray, int n) {
        return objectArray[n] != LazyPropertyInitializer.UNFETCHED_PROPERTY;
    }

    Object processComponent(Object object, CompositeType compositeType) throws HibernateException {
        if (object != null) {
            this.processValues(compositeType.getPropertyValues(object, this.session), compositeType.getSubtypes());
        }
        return null;
    }

    final Object processValue(Object object, Type type) throws HibernateException {
        if (type.isCollectionType()) {
            return this.processCollection(object, (CollectionType)type);
        }
        if (type.isEntityType()) {
            return this.processEntity(object, (EntityType)type);
        }
        if (type.isComponentType()) {
            return this.processComponent(object, (CompositeType)type);
        }
        return null;
    }

    void process(Object object, EntityPersister entityPersister) throws HibernateException {
        this.processEntityPropertyValues(entityPersister.getPropertyValues(object), entityPersister.getPropertyTypes());
    }

    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        return null;
    }

    Object processEntity(Object object, EntityType entityType) throws HibernateException {
        return null;
    }

    final EventSource getSession() {
        return this.session;
    }
}

