/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public abstract class AbstractSaveEventListener
extends AbstractReassociateEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractSaveEventListener.class.getName());

    protected Serializable saveWithRequestedId(Object object, Serializable serializable, String string, Object object2, EventSource eventSource) {
        return this.performSave(object, serializable, eventSource.getEntityPersister(string, object), false, object2, eventSource, true);
    }

    protected Serializable saveWithGeneratedId(Object object, String string, Object object2, EventSource eventSource, boolean bl) {
        EntityPersister entityPersister = eventSource.getEntityPersister(string, object);
        Serializable serializable = entityPersister.getIdentifierGenerator().generate(eventSource, object);
        if (serializable == null) {
            throw new IdentifierGenerationException("null id generated for:" + object.getClass());
        }
        if (serializable == IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR) {
            return eventSource.getIdentifier(object);
        }
        if (serializable == IdentifierGeneratorHelper.POST_INSERT_INDICATOR) {
            return this.performSave(object, null, entityPersister, true, object2, eventSource, bl);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Generated identifier: %s, using strategy: %s", (Object)entityPersister.getIdentifierType().toLoggableString(serializable, eventSource.getFactory()), (Object)entityPersister.getIdentifierGenerator().getClass().getName());
        }
        return this.performSave(object, serializable, entityPersister, false, object2, eventSource, true);
    }

    protected Serializable performSave(Object object, Serializable serializable, EntityPersister entityPersister, boolean bl, Object object2, EventSource eventSource, boolean bl2) {
        EntityKey entityKey;
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Saving {0}", (Object)MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
        }
        if (!bl) {
            entityKey = eventSource.generateEntityKey(serializable, entityPersister);
            Object object3 = eventSource.getPersistenceContext().getEntity(entityKey);
            if (object3 != null) {
                if (eventSource.getPersistenceContext().getEntry(object3).getStatus() == Status.DELETED) {
                    eventSource.forceFlush(eventSource.getPersistenceContext().getEntry(object3));
                } else {
                    throw new NonUniqueObjectException(serializable, entityPersister.getEntityName());
                }
            }
            entityPersister.setIdentifier(object, serializable, eventSource);
        } else {
            entityKey = null;
        }
        if (this.invokeSaveLifecycle(object, entityPersister, eventSource)) {
            return serializable;
        }
        return this.performSaveOrReplicate(object, entityKey, entityPersister, bl, object2, eventSource, bl2);
    }

    protected boolean invokeSaveLifecycle(Object object, EntityPersister entityPersister, EventSource eventSource) {
        if (entityPersister.implementsLifecycle()) {
            LOG.debug("Calling onSave()");
            if (((Lifecycle)object).onSave(eventSource)) {
                LOG.debug("Insertion vetoed by onSave()");
                return true;
            }
        }
        return false;
    }

    protected Serializable performSaveOrReplicate(Object object, EntityKey entityKey, EntityPersister entityPersister, boolean bl, Object object2, EventSource eventSource, boolean bl2) {
        Serializable serializable = entityKey == null ? null : entityKey.getIdentifier();
        boolean bl3 = eventSource.getTransactionCoordinator().isTransactionInProgress();
        boolean bl4 = !bl3 && !bl2;
        eventSource.getPersistenceContext().addEntry(object, Status.SAVING, null, null, serializable, null, LockMode.WRITE, bl, entityPersister, false, false);
        this.cascadeBeforeSave(eventSource, entityPersister, object, object2);
        Object[] objectArray = entityPersister.getPropertyValuesToInsert(object, this.getMergeMap(object2), eventSource);
        Type[] typeArray = entityPersister.getPropertyTypes();
        boolean bl5 = this.substituteValuesIfNecessary(object, serializable, objectArray, entityPersister, eventSource);
        if (entityPersister.hasCollections()) {
            boolean bl6 = bl5 = bl5 || this.visitCollectionsBeforeSave(object, serializable, objectArray, typeArray, eventSource);
        }
        if (bl5) {
            entityPersister.setPropertyValues(object, objectArray);
        }
        TypeHelper.deepCopy(objectArray, typeArray, entityPersister.getPropertyUpdateability(), objectArray, eventSource);
        AbstractEntityInsertAction abstractEntityInsertAction = this.addInsertAction(objectArray, serializable, object, entityPersister, bl, eventSource, bl4);
        this.cascadeAfterSave(eventSource, entityPersister, object, object2);
        if (bl && abstractEntityInsertAction.isEarlyInsert()) {
            if (!EntityIdentityInsertAction.class.isInstance(abstractEntityInsertAction)) {
                throw new IllegalStateException("Insert should be using an identity column, but action is of unexpected type: " + abstractEntityInsertAction.getClass().getName());
            }
            serializable = ((EntityIdentityInsertAction)abstractEntityInsertAction).getGeneratedId();
            abstractEntityInsertAction.handleNaturalIdPostSaveNotifications(serializable);
        }
        this.markInterceptorDirty(object, entityPersister, eventSource);
        return serializable;
    }

    private AbstractEntityInsertAction addInsertAction(Object[] objectArray, Serializable serializable, Object object, EntityPersister entityPersister, boolean bl, EventSource eventSource, boolean bl2) {
        if (bl) {
            EntityIdentityInsertAction entityIdentityInsertAction = new EntityIdentityInsertAction(objectArray, object, entityPersister, this.isVersionIncrementDisabled(), eventSource, bl2);
            eventSource.getActionQueue().addAction(entityIdentityInsertAction);
            return entityIdentityInsertAction;
        }
        Object object2 = Versioning.getVersion(objectArray, entityPersister);
        EntityInsertAction entityInsertAction = new EntityInsertAction(serializable, objectArray, object, object2, entityPersister, this.isVersionIncrementDisabled(), eventSource);
        eventSource.getActionQueue().addAction(entityInsertAction);
        return entityInsertAction;
    }

    private void markInterceptorDirty(Object object, EntityPersister entityPersister, EventSource eventSource) {
        if (entityPersister.getInstrumentationMetadata().isInstrumented()) {
            FieldInterceptor fieldInterceptor = entityPersister.getInstrumentationMetadata().injectInterceptor(object, entityPersister.getEntityName(), null, eventSource);
            fieldInterceptor.dirty();
        }
    }

    protected Map getMergeMap(Object object) {
        return null;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollectionsBeforeSave(Object object, Serializable serializable, Object[] objectArray, Type[] typeArray, EventSource eventSource) {
        WrapVisitor wrapVisitor = new WrapVisitor(eventSource);
        wrapVisitor.processEntityPropertyValues(objectArray, typeArray);
        return wrapVisitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object object, Serializable serializable, Object[] objectArray, EntityPersister entityPersister, SessionImplementor sessionImplementor) {
        boolean bl = sessionImplementor.getInterceptor().onSave(object, serializable, objectArray, entityPersister.getPropertyNames(), entityPersister.getPropertyTypes());
        if (entityPersister.isVersioned()) {
            bl = Versioning.seedVersion(objectArray, entityPersister.getVersionProperty(), entityPersister.getVersionType(), sessionImplementor) || bl;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 2, eventSource).cascade(entityPersister, object, object2);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 1, eventSource).cascade(entityPersister, object, object2);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected abstract CascadingAction getCascadeAction();

    protected EntityState getEntityState(Object object, String string, EntityEntry entityEntry, SessionImplementor sessionImplementor) {
        boolean bl = LOG.isTraceEnabled();
        if (entityEntry != null) {
            if (entityEntry.getStatus() != Status.DELETED) {
                if (bl) {
                    LOG.tracev("Persistent instance of: {0}", (Object)this.getLoggableName(string, object));
                }
                return EntityState.PERSISTENT;
            }
            if (bl) {
                LOG.tracev("Deleted instance of: {0}", (Object)this.getLoggableName(string, object));
            }
            return EntityState.DELETED;
        }
        if (ForeignKeys.isTransient(string, object, this.getAssumedUnsaved(), sessionImplementor)) {
            if (bl) {
                LOG.tracev("Transient instance of: {0}", (Object)this.getLoggableName(string, object));
            }
            return EntityState.TRANSIENT;
        }
        if (bl) {
            LOG.tracev("Detached instance of: {0}", (Object)this.getLoggableName(string, object));
        }
        return EntityState.DETACHED;
    }

    protected String getLoggableName(String string, Object object) {
        return string == null ? object.getClass().getName() : string;
    }

    protected Boolean getAssumedUnsaved() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntityState {
        PERSISTENT,
        TRANSIENT,
        DETACHED,
        DELETED;

    }
}

