/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.LockMode;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.OnLockVisitor;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public class AbstractReassociateEventListener
implements Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractReassociateEventListener.class.getName());

    protected final EntityEntry reassociate(AbstractEvent abstractEvent, Object object, Serializable serializable, EntityPersister entityPersister) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Reassociating transient instance: {0}", (Object)MessageHelper.infoString(entityPersister, serializable, abstractEvent.getSession().getFactory()));
        }
        EventSource eventSource = abstractEvent.getSession();
        EntityKey entityKey = eventSource.generateEntityKey(serializable, entityPersister);
        eventSource.getPersistenceContext().checkUniqueness(entityKey, object);
        Object[] objectArray = entityPersister.getPropertyValues(object);
        TypeHelper.deepCopy(objectArray, entityPersister.getPropertyTypes(), entityPersister.getPropertyUpdateability(), objectArray, eventSource);
        Object object2 = Versioning.getVersion(objectArray, entityPersister);
        EntityEntry entityEntry = eventSource.getPersistenceContext().addEntity(object, entityPersister.isMutable() ? Status.MANAGED : Status.READ_ONLY, objectArray, entityKey, object2, LockMode.NONE, true, entityPersister, false, true);
        new OnLockVisitor(eventSource, serializable, object).process(object, entityPersister);
        entityPersister.afterReassociate(object, eventSource);
        return entityEntry;
    }
}

