/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public class AbstractLockUpgradeEventListener
extends AbstractReassociateEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractLockUpgradeEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void upgradeLock(Object object, EntityEntry entityEntry, LockOptions lockOptions, EventSource eventSource) {
        SoftLock softLock;
        CacheKey cacheKey;
        LockMode lockMode = lockOptions.getLockMode();
        if (!lockMode.greaterThan(entityEntry.getLockMode())) return;
        if (entityEntry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entityEntry.getId(), entityEntry.getPersister().getEntityName());
        }
        EntityPersister entityPersister = entityEntry.getPersister();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Locking {0} in mode: {1}", (Object)MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()), (Object)lockMode);
        }
        if (entityPersister.hasCache()) {
            cacheKey = eventSource.generateCacheKey(entityEntry.getId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName());
            softLock = entityPersister.getCacheAccessStrategy().lockItem(cacheKey, entityEntry.getVersion());
        } else {
            cacheKey = null;
            softLock = null;
        }
        try {
            if (entityPersister.isVersioned() && lockMode == LockMode.FORCE) {
                Object object2 = entityPersister.forceVersionIncrement(entityEntry.getId(), entityEntry.getVersion(), eventSource);
                entityEntry.forceLocked(object, object2);
            } else {
                entityPersister.lock(entityEntry.getId(), entityEntry.getVersion(), object, lockOptions, (SessionImplementor)eventSource);
            }
            entityEntry.setLockMode(lockMode);
            if (!entityPersister.hasCache()) return;
        }
        catch (Throwable throwable) {
            if (!entityPersister.hasCache()) throw throwable;
            entityPersister.getCacheAccessStrategy().unlockItem(cacheKey, softLock);
            throw throwable;
        }
        entityPersister.getCacheAccessStrategy().unlockItem(cacheKey, softLock);
    }
}

