/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionRecreateAction;
import org.hibernate.action.internal.CollectionRemoveAction;
import org.hibernate.action.internal.CollectionUpdateAction;
import org.hibernate.action.internal.QueuedOperationCollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.Collections;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEntityEvent;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.EntityPrinter;
import org.hibernate.internal.util.collections.IdentityMap;
import org.hibernate.internal.util.collections.LazyIterator;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public abstract class AbstractFlushingEventListener
implements Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractFlushingEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushEverythingToExecutions(FlushEvent flushEvent) throws HibernateException {
        LOG.trace("Flushing session");
        EventSource eventSource = flushEvent.getSession();
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        eventSource.getInterceptor().preFlush(new LazyIterator(persistenceContext.getEntitiesByKey()));
        this.prepareEntityFlushes(eventSource, persistenceContext);
        this.prepareCollectionFlushes(persistenceContext);
        persistenceContext.setFlushing(true);
        try {
            this.flushEntities(flushEvent, persistenceContext);
            this.flushCollections(eventSource, persistenceContext);
        }
        finally {
            persistenceContext.setFlushing(false);
        }
        this.logFlushResults(flushEvent);
    }

    private void logFlushResults(FlushEvent flushEvent) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        EventSource eventSource = flushEvent.getSession();
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        LOG.debugf("Flushed: %s insertions, %s updates, %s deletions to %s objects", eventSource.getActionQueue().numberOfInsertions(), eventSource.getActionQueue().numberOfUpdates(), eventSource.getActionQueue().numberOfDeletions(), persistenceContext.getNumberOfManagedEntities());
        LOG.debugf("Flushed: %s (re)creations, %s updates, %s removals to %s collections", eventSource.getActionQueue().numberOfCollectionCreations(), eventSource.getActionQueue().numberOfCollectionUpdates(), eventSource.getActionQueue().numberOfCollectionRemovals(), persistenceContext.getCollectionEntries().size());
        new EntityPrinter(eventSource.getFactory()).toString(persistenceContext.getEntitiesByKey().entrySet());
    }

    private void prepareEntityFlushes(EventSource eventSource, PersistenceContext persistenceContext) throws HibernateException {
        LOG.debug("Processing flush-time cascades");
        Object object = this.getAnything();
        for (Map.Entry<Object, EntityEntry> entry : persistenceContext.reentrantSafeEntityEntries()) {
            EntityEntry entityEntry = entry.getValue();
            Status status = entityEntry.getStatus();
            if (status != Status.MANAGED && status != Status.SAVING && status != Status.READ_ONLY) continue;
            this.cascadeOnFlush(eventSource, entityEntry.getPersister(), entry.getKey(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnFlush(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) throws HibernateException {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadingAction(), 0, eventSource).cascade(entityPersister, object, object2);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected Object getAnything() {
        return null;
    }

    protected CascadingAction getCascadingAction() {
        return CascadingAction.SAVE_UPDATE;
    }

    private void prepareCollectionFlushes(PersistenceContext persistenceContext) throws HibernateException {
        LOG.debug("Dirty checking collections");
        for (Map.Entry entry : IdentityMap.concurrentEntries(persistenceContext.getCollectionEntries())) {
            ((CollectionEntry)entry.getValue()).preFlush((PersistentCollection)entry.getKey());
        }
    }

    private void flushEntities(FlushEvent flushEvent, PersistenceContext persistenceContext) throws HibernateException {
        LOG.trace("Flushing entities and processing referenced collections");
        EventSource eventSource = flushEvent.getSession();
        Iterable<FlushEntityEventListener> iterable = eventSource.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.FLUSH_ENTITY).listeners();
        for (Map.Entry<Object, EntityEntry> entry : persistenceContext.reentrantSafeEntityEntries()) {
            EntityEntry entityEntry = entry.getValue();
            Status status = entityEntry.getStatus();
            if (status == Status.LOADING || status == Status.GONE) continue;
            FlushEntityEvent flushEntityEvent = new FlushEntityEvent(eventSource, entry.getKey(), entityEntry);
            for (FlushEntityEventListener flushEntityEventListener : iterable) {
                flushEntityEventListener.onFlushEntity(flushEntityEvent);
            }
        }
        eventSource.getActionQueue().sortActions();
    }

    private void flushCollections(EventSource eventSource, PersistenceContext persistenceContext) throws HibernateException {
        LOG.trace("Processing unreferenced collections");
        for (Map.Entry entry : IdentityMap.concurrentEntries(persistenceContext.getCollectionEntries())) {
            CollectionEntry object = (CollectionEntry)entry.getValue();
            if (object.isReached() || object.isIgnore()) continue;
            Collections.processUnreachableCollection((PersistentCollection)entry.getKey(), eventSource);
        }
        LOG.trace("Scheduling collection removes/(re)creates/updates");
        ActionQueue actionQueue = eventSource.getActionQueue();
        for (Map.Entry entry : IdentityMap.concurrentEntries(persistenceContext.getCollectionEntries())) {
            PersistentCollection persistentCollection = (PersistentCollection)entry.getKey();
            CollectionEntry collectionEntry = (CollectionEntry)entry.getValue();
            if (collectionEntry.isDorecreate()) {
                eventSource.getInterceptor().onCollectionRecreate(persistentCollection, collectionEntry.getCurrentKey());
                actionQueue.addAction(new CollectionRecreateAction(persistentCollection, collectionEntry.getCurrentPersister(), collectionEntry.getCurrentKey(), (SessionImplementor)eventSource));
            }
            if (collectionEntry.isDoremove()) {
                eventSource.getInterceptor().onCollectionRemove(persistentCollection, collectionEntry.getLoadedKey());
                actionQueue.addAction(new CollectionRemoveAction(persistentCollection, collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), collectionEntry.isSnapshotEmpty(persistentCollection), (SessionImplementor)eventSource));
            }
            if (collectionEntry.isDoupdate()) {
                eventSource.getInterceptor().onCollectionUpdate(persistentCollection, collectionEntry.getLoadedKey());
                actionQueue.addAction(new CollectionUpdateAction(persistentCollection, collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), collectionEntry.isSnapshotEmpty(persistentCollection), eventSource));
            }
            if (persistentCollection.wasInitialized() || !persistentCollection.hasQueuedOperations()) continue;
            actionQueue.addAction(new QueuedOperationCollectionAction(persistentCollection, collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), (SessionImplementor)eventSource));
        }
        actionQueue.sortCollectionActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performExecutions(EventSource eventSource) {
        LOG.trace("Executing flush");
        try {
            eventSource.getTransactionCoordinator().getJdbcCoordinator().flushBeginning();
            eventSource.getPersistenceContext().setFlushing(true);
            eventSource.getActionQueue().prepareActions();
            eventSource.getActionQueue().executeActions();
        }
        finally {
            eventSource.getPersistenceContext().setFlushing(false);
            eventSource.getTransactionCoordinator().getJdbcCoordinator().flushEnding();
        }
    }

    protected void postFlush(SessionImplementor sessionImplementor) throws HibernateException {
        LOG.trace("Post flush");
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        persistenceContext.getCollectionsByKey().clear();
        persistenceContext.getBatchFetchQueue().clear();
        for (Map.Entry entry : IdentityMap.concurrentEntries(persistenceContext.getCollectionEntries())) {
            CollectionEntry collectionEntry = (CollectionEntry)entry.getValue();
            PersistentCollection persistentCollection = (PersistentCollection)entry.getKey();
            collectionEntry.postFlush(persistentCollection);
            if (collectionEntry.getLoadedPersister() == null) {
                persistenceContext.getCollectionEntries().remove(persistentCollection);
                continue;
            }
            CollectionKey collectionKey = new CollectionKey(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey());
            persistenceContext.getCollectionsByKey().put(collectionKey, persistentCollection);
        }
        sessionImplementor.getInterceptor().postFlush(new LazyIterator(persistenceContext.getEntitiesByKey()));
    }
}

