/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.synchronization.internal;

import javax.transaction.SystemException;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.synchronization.spi.AfterCompletionAction;
import org.hibernate.engine.transaction.synchronization.spi.ExceptionMapper;
import org.hibernate.engine.transaction.synchronization.spi.ManagedFlushChecker;
import org.hibernate.engine.transaction.synchronization.spi.SynchronizationCallbackCoordinator;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class SynchronizationCallbackCoordinatorImpl
implements SynchronizationCallbackCoordinator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SynchronizationCallbackCoordinatorImpl.class.getName());
    private final TransactionCoordinator transactionCoordinator;
    private final Settings settings;
    private ManagedFlushChecker managedFlushChecker;
    private AfterCompletionAction afterCompletionAction;
    private ExceptionMapper exceptionMapper;
    private volatile long registrationThreadId;
    private final int NO_STATUS = -1;
    private volatile int delayedCompletionHandlingStatus;
    private static final ManagedFlushChecker STANDARD_MANAGED_FLUSH_CHECKER = new ManagedFlushChecker(){

        public boolean shouldDoManagedFlush(TransactionCoordinator transactionCoordinator, int n) {
            return !transactionCoordinator.getTransactionContext().isClosed() && !transactionCoordinator.getTransactionContext().isFlushModeNever() && transactionCoordinator.getTransactionContext().isFlushBeforeCompletionEnabled() && !JtaStatusHelper.isRollback(n);
        }
    };
    private static final ExceptionMapper STANDARD_EXCEPTION_MAPPER = new ExceptionMapper(){

        public RuntimeException mapStatusCheckFailure(String string, SystemException systemException) {
            LOG.error(LOG.unableToDetermineTransactionStatus(), systemException);
            return new TransactionException("could not determine transaction status in beforeCompletion()", systemException);
        }

        public RuntimeException mapManagedFlushFailure(String string, RuntimeException runtimeException) {
            LOG.unableToPerformManagedFlush(runtimeException.getMessage());
            return runtimeException;
        }
    };
    private static final AfterCompletionAction STANDARD_AFTER_COMPLETION_ACTION = new AfterCompletionAction(){

        public void doAction(TransactionCoordinator transactionCoordinator, int n) {
        }
    };

    public SynchronizationCallbackCoordinatorImpl(TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
        this.settings = transactionCoordinator.getTransactionContext().getTransactionEnvironment().getSessionFactory().getSettings();
        this.reset();
        this.pulse();
    }

    public void reset() {
        this.managedFlushChecker = STANDARD_MANAGED_FLUSH_CHECKER;
        this.exceptionMapper = STANDARD_EXCEPTION_MAPPER;
        this.afterCompletionAction = STANDARD_AFTER_COMPLETION_ACTION;
        this.delayedCompletionHandlingStatus = -1;
    }

    public void setManagedFlushChecker(ManagedFlushChecker managedFlushChecker) {
        this.managedFlushChecker = managedFlushChecker;
    }

    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    public void setAfterCompletionAction(AfterCompletionAction afterCompletionAction) {
        this.afterCompletionAction = afterCompletionAction;
    }

    public void beforeCompletion() {
        boolean bl;
        LOG.trace("Transaction before completion callback");
        try {
            int n = this.transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJtaPlatform().getCurrentStatus();
            bl = this.managedFlushChecker.shouldDoManagedFlush(this.transactionCoordinator, n);
        }
        catch (SystemException systemException) {
            this.setRollbackOnly();
            throw this.exceptionMapper.mapStatusCheckFailure("could not determine transaction status in beforeCompletion()", systemException);
        }
        try {
            if (bl) {
                LOG.trace("Automatically flushing session");
                this.transactionCoordinator.getTransactionContext().managedFlush();
            }
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw this.exceptionMapper.mapManagedFlushFailure("error during managed flush", runtimeException);
        }
        finally {
            this.transactionCoordinator.sendBeforeTransactionCompletionNotifications(null);
            this.transactionCoordinator.getTransactionContext().beforeTransactionCompletion(null);
        }
    }

    private void setRollbackOnly() {
        this.transactionCoordinator.setRollbackOnly();
    }

    public void afterCompletion(int n) {
        if (this.settings.isJtaTrackByThread() && !this.isRegistrationThread() && JtaStatusHelper.isRollback(n)) {
            LOG.warnv("Transaction afterCompletion called by a background thread! Delaying action until the original thread can handle it. [status={0}]", (Object)n);
            this.delayedCompletionHandlingStatus = n;
        } else {
            this.doAfterCompletion(n);
        }
    }

    public void pulse() {
        if (this.settings.isJtaTrackByThread()) {
            this.registrationThreadId = Thread.currentThread().getId();
        }
    }

    public void delayedAfterCompletion() {
        if (this.delayedCompletionHandlingStatus != -1) {
            this.doAfterCompletion(this.delayedCompletionHandlingStatus);
            this.delayedCompletionHandlingStatus = -1;
            throw new HibernateException("Transaction was rolled back in a different thread!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAfterCompletion(int n) {
        LOG.tracev("Transaction afterCompletion callback [status={0}]", (Object)n);
        try {
            this.afterCompletionAction.doAction(this.transactionCoordinator, n);
            this.transactionCoordinator.afterTransaction(null, n);
        }
        finally {
            this.reset();
            if (this.transactionContext().shouldAutoClose() && !this.transactionContext().isClosed()) {
                LOG.trace("Automatically closing session");
                this.transactionContext().managedClose();
            }
        }
    }

    private boolean isRegistrationThread() {
        return Thread.currentThread().getId() == this.registrationThreadId;
    }

    private TransactionContext transactionContext() {
        return this.transactionCoordinator.getTransactionContext();
    }
}

