/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jta;

import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.internal.jta.JtaTransaction;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtaTransactionFactory
implements TransactionFactory<JtaTransaction> {
    @Override
    public JtaTransaction createTransaction(TransactionCoordinator transactionCoordinator) {
        return new JtaTransaction(transactionCoordinator);
    }

    @Override
    public boolean canBeDriver() {
        return true;
    }

    @Override
    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    @Override
    public boolean compatibleWithJtaSynchronization() {
        return true;
    }

    @Override
    public boolean isJoinableJtaTransaction(TransactionCoordinator transactionCoordinator, JtaTransaction jtaTransaction) {
        try {
            Object object;
            if (jtaTransaction != null && (object = jtaTransaction.getUserTransaction()) != null) {
                return JtaStatusHelper.isActive((UserTransaction)object);
            }
            object = transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJtaPlatform();
            if (object == null) {
                throw new TransactionException("Unable to check transaction status");
            }
            if (object.retrieveTransactionManager() != null) {
                return JtaStatusHelper.isActive(object.retrieveTransactionManager().getStatus());
            }
            UserTransaction userTransaction = object.retrieveUserTransaction();
            return userTransaction != null && JtaStatusHelper.isActive(userTransaction);
        }
        catch (SystemException systemException) {
            throw new TransactionException("Unable to check transaction status", systemException);
        }
    }
}

