/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jta;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jta.JtaIsolationDelegate;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.spi.AbstractTransactionImpl;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.JoinStatus;
import org.hibernate.engine.transaction.spi.LocalStatus;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class JtaTransaction
extends AbstractTransactionImpl {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JtaTransaction.class.getName());
    private UserTransaction userTransaction;
    private boolean isInitiator;
    private boolean isDriver;

    protected JtaTransaction(TransactionCoordinator transactionCoordinator) {
        super(transactionCoordinator);
    }

    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    protected void doBegin() {
        LOG.debug("begin");
        this.userTransaction = this.locateUserTransaction();
        try {
            if (this.userTransaction.getStatus() == 6) {
                this.userTransaction.begin();
                this.isInitiator = true;
                LOG.debug("Began a new JTA transaction");
            }
        }
        catch (Exception exception) {
            throw new TransactionException("JTA transaction begin failed", exception);
        }
    }

    private UserTransaction locateUserTransaction() {
        UserTransaction userTransaction = this.jtaPlatform().retrieveUserTransaction();
        if (userTransaction == null) {
            throw new TransactionException("Unable to locate JTA UserTransaction");
        }
        return userTransaction;
    }

    protected void afterTransactionBegin() {
        this.transactionCoordinator().pulse();
        if (!this.transactionCoordinator().isSynchronizationRegistered()) {
            this.isDriver = this.transactionCoordinator().takeOwnership();
        }
        this.applyTimeout();
        this.transactionCoordinator().sendAfterTransactionBeginNotifications(this);
        this.transactionCoordinator().getTransactionContext().afterTransactionBegin(this);
    }

    private void applyTimeout() {
        if (this.getTimeout() > 0) {
            if (this.userTransaction != null) {
                try {
                    this.userTransaction.setTransactionTimeout(this.getTimeout());
                }
                catch (SystemException systemException) {
                    throw new TransactionException("Unable to apply requested transaction timeout", systemException);
                }
            } else {
                LOG.debug("Unable to apply requested transaction timeout; no UserTransaction.  Will try later");
            }
        }
    }

    protected void beforeTransactionCommit() {
        boolean bl;
        this.transactionCoordinator().sendBeforeTransactionCompletionNotifications(this);
        boolean bl2 = bl = !this.transactionCoordinator().getTransactionContext().isFlushModeNever() && (this.isDriver || !this.transactionCoordinator().getTransactionContext().isFlushBeforeCompletionEnabled());
        if (bl) {
            this.transactionCoordinator().getTransactionContext().managedFlush();
        }
        if (this.isDriver && this.isInitiator) {
            this.transactionCoordinator().getTransactionContext().beforeTransactionCompletion(this);
        }
        this.closeIfRequired();
    }

    private void closeIfRequired() throws HibernateException {
        boolean bl;
        boolean bl2 = bl = this.isDriver && this.transactionCoordinator().getTransactionContext().shouldAutoClose() && !this.transactionCoordinator().getTransactionContext().isClosed();
        if (bl) {
            this.transactionCoordinator().getTransactionContext().managedClose();
        }
    }

    protected void doCommit() {
        try {
            if (this.isInitiator) {
                this.userTransaction.commit();
                LOG.debug("Committed JTA UserTransaction");
            }
        }
        catch (Exception exception) {
            throw new TransactionException("JTA commit failed: ", exception);
        }
        finally {
            this.isInitiator = false;
        }
    }

    protected void afterTransactionCompletion(int n) {
    }

    protected void afterAfterCompletion() {
        if (this.isDriver) {
            if (!this.isInitiator) {
                LOG.setManagerLookupClass();
            }
            try {
                this.transactionCoordinator().afterTransaction(this, this.userTransaction.getStatus());
            }
            catch (SystemException systemException) {
                throw new TransactionException("Unable to determine UserTransaction status", systemException);
            }
        }
    }

    protected void beforeTransactionRollBack() {
    }

    protected void doRollback() {
        try {
            if (this.isInitiator) {
                if (this.getLocalStatus() != LocalStatus.FAILED_COMMIT) {
                    this.userTransaction.rollback();
                    LOG.debug("Rolled back JTA UserTransaction");
                }
            } else {
                this.markRollbackOnly();
            }
        }
        catch (Exception exception) {
            throw new TransactionException("JTA rollback failed", exception);
        }
    }

    public void markRollbackOnly() {
        LOG.trace("Marking transaction for rollback only");
        try {
            if (this.userTransaction == null) {
                this.userTransaction = this.locateUserTransaction();
            }
            this.userTransaction.setRollbackOnly();
            LOG.debug("set JTA UserTransaction to rollback only");
        }
        catch (SystemException systemException) {
            LOG.debug("Unable to mark transaction for rollback only", systemException);
        }
    }

    public IsolationDelegate createIsolationDelegate() {
        return new JtaIsolationDelegate(this.transactionCoordinator());
    }

    public boolean isInitiator() {
        return this.isInitiator;
    }

    public boolean isActive() throws HibernateException {
        int n;
        if (this.getLocalStatus() != LocalStatus.ACTIVE) {
            return false;
        }
        try {
            n = this.userTransaction.getStatus();
        }
        catch (SystemException systemException) {
            throw new TransactionException("Could not determine transaction status: ", systemException);
        }
        return JtaStatusHelper.isActive(n);
    }

    public void setTimeout(int n) {
        super.setTimeout(n);
        this.applyTimeout();
    }

    public void join() {
    }

    public void resetJoinStatus() {
    }

    public JoinStatus getJoinStatus() {
        if (this.userTransaction != null) {
            return JtaStatusHelper.isActive(this.userTransaction) ? JoinStatus.JOINED : JoinStatus.NOT_JOINED;
        }
        TransactionManager transactionManager = this.jtaPlatform().retrieveTransactionManager();
        if (transactionManager != null) {
            return JtaStatusHelper.isActive(transactionManager) ? JoinStatus.JOINED : JoinStatus.NOT_JOINED;
        }
        UserTransaction userTransaction = this.jtaPlatform().retrieveUserTransaction();
        return userTransaction != null && JtaStatusHelper.isActive(userTransaction) ? JoinStatus.JOINED : JoinStatus.NOT_JOINED;
    }
}

