/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jta;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.TransactionException;

public class JtaStatusHelper {
    public static int getStatus(UserTransaction userTransaction) {
        try {
            int n = userTransaction.getStatus();
            if (n == 5) {
                throw new TransactionException("UserTransaction reported transaction status as unknown");
            }
            return n;
        }
        catch (SystemException systemException) {
            throw new TransactionException("Could not determine transaction status", systemException);
        }
    }

    public static int getStatus(TransactionManager transactionManager) {
        try {
            int n = transactionManager.getStatus();
            if (n == 5) {
                throw new TransactionException("TransactionManager reported transaction status as unknwon");
            }
            return n;
        }
        catch (SystemException systemException) {
            throw new TransactionException("Could not determine transaction status", systemException);
        }
    }

    public static boolean isActive(int n) {
        return n == 0;
    }

    public static boolean isActive(UserTransaction userTransaction) {
        int n = JtaStatusHelper.getStatus(userTransaction);
        return JtaStatusHelper.isActive(n);
    }

    public static boolean isActive(TransactionManager transactionManager) {
        return JtaStatusHelper.isActive(JtaStatusHelper.getStatus(transactionManager));
    }

    public static boolean isRollback(int n) {
        return n == 1 || n == 9 || n == 4;
    }

    public static boolean isRollback(UserTransaction userTransaction) {
        return JtaStatusHelper.isRollback(JtaStatusHelper.getStatus(userTransaction));
    }

    public static boolean isRollback(TransactionManager transactionManager) {
        return JtaStatusHelper.isRollback(JtaStatusHelper.getStatus(transactionManager));
    }

    public static boolean isCommitted(int n) {
        return n == 3;
    }

    public static boolean isCommitted(UserTransaction userTransaction) {
        return JtaStatusHelper.isCommitted(JtaStatusHelper.getStatus(userTransaction));
    }

    public static boolean isCommitted(TransactionManager transactionManager) {
        return JtaStatusHelper.isCommitted(JtaStatusHelper.getStatus(transactionManager));
    }

    public static boolean isMarkedForRollback(int n) {
        return n == 1;
    }
}

