/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jta;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtaIsolationDelegate
implements IsolationDelegate {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JtaIsolationDelegate.class.getName());
    private final TransactionCoordinator transactionCoordinator;

    public JtaIsolationDelegate(TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
    }

    protected TransactionManager transactionManager() {
        return this.transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJtaPlatform().retrieveTransactionManager();
    }

    protected JdbcConnectionAccess jdbcConnectionAccess() {
        return this.transactionCoordinator.getTransactionContext().getJdbcConnectionAccess();
    }

    protected SqlExceptionHelper sqlExceptionHelper() {
        return this.transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJdbcServices().getSqlExceptionHelper();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T delegateWork(WorkExecutorVisitable<T> workExecutorVisitable, boolean bl) throws HibernateException {
        TransactionManager transactionManager = this.transactionManager();
        try {
            Transaction transaction = transactionManager.suspend();
            LOG.debugf("Surrounding JTA transaction suspended [%s]", (Object)transaction);
            boolean bl2 = false;
            try {
                if (bl) {
                    T t = this.doTheWorkInNewTransaction(workExecutorVisitable, transactionManager);
                    return t;
                }
                T t = this.doTheWorkInNoTransaction(workExecutorVisitable);
                return t;
            }
            catch (HibernateException hibernateException) {
                bl2 = true;
                throw hibernateException;
            }
            finally {
                block15: {
                    try {
                        transactionManager.resume(transaction);
                        LOG.debugf("Surrounding JTA transaction resumed [%s]", (Object)transaction);
                    }
                    catch (Throwable throwable) {
                        if (bl2) break block15;
                        throw new HibernateException("Unable to resume previously suspended transaction", throwable);
                    }
                }
            }
        }
        catch (SystemException systemException) {
            throw new HibernateException("Unable to suspend current JTA transaction", systemException);
        }
    }

    private <T> T doTheWorkInNewTransaction(WorkExecutorVisitable<T> workExecutorVisitable, TransactionManager transactionManager) {
        try {
            transactionManager.begin();
            try {
                T t = this.doTheWork(workExecutorVisitable);
                transactionManager.commit();
                return t;
            }
            catch (Exception exception) {
                try {
                    transactionManager.rollback();
                }
                catch (Exception exception2) {
                    LOG.unableToRollbackIsolatedTransaction(exception, exception2);
                }
                throw new HibernateException("Could not apply work", exception);
            }
        }
        catch (SystemException systemException) {
            throw new HibernateException("Unable to start isolated transaction", systemException);
        }
        catch (NotSupportedException notSupportedException) {
            throw new HibernateException("Unable to start isolated transaction", notSupportedException);
        }
    }

    private <T> T doTheWorkInNoTransaction(WorkExecutorVisitable<T> workExecutorVisitable) {
        return this.doTheWork(workExecutorVisitable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doTheWork(WorkExecutorVisitable<T> workExecutorVisitable) {
        try {
            Connection connection = this.jdbcConnectionAccess().obtainConnection();
            try {
                Object t = workExecutorVisitable.accept(new WorkExecutor(), connection);
                return t;
            }
            catch (HibernateException hibernateException) {
                throw hibernateException;
            }
            catch (Exception exception) {
                throw new HibernateException("Unable to perform isolated work", exception);
            }
            finally {
                try {
                    this.jdbcConnectionAccess().releaseConnection(connection);
                }
                catch (Throwable throwable) {
                    LOG.unableToReleaseIsolatedConnection(throwable);
                }
            }
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "unable to obtain isolated JDBC connection");
        }
    }
}

