/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcIsolationDelegate
implements IsolationDelegate {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JdbcIsolationDelegate.class.getName());
    private final TransactionCoordinator transactionCoordinator;

    public JdbcIsolationDelegate(TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
    }

    protected JdbcConnectionAccess jdbcConnectionAccess() {
        return this.transactionCoordinator.getTransactionContext().getJdbcConnectionAccess();
    }

    protected SqlExceptionHelper sqlExceptionHelper() {
        return this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().getJdbcServices().getSqlExceptionHelper();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T delegateWork(WorkExecutorVisitable<T> workExecutorVisitable, boolean bl) throws HibernateException {
        boolean bl2 = false;
        try {
            Connection connection = this.jdbcConnectionAccess().obtainConnection();
            try {
                if (bl && connection.getAutoCommit()) {
                    bl2 = true;
                    connection.setAutoCommit(false);
                }
                Object t = workExecutorVisitable.accept(new WorkExecutor(), connection);
                if (bl) {
                    connection.commit();
                }
                Object t2 = t;
                return t2;
            }
            catch (Exception exception) {
                try {
                    if (bl && !connection.isClosed()) {
                        connection.rollback();
                    }
                }
                catch (Exception exception2) {
                    LOG.unableToRollbackConnection(exception2);
                }
                if (exception instanceof HibernateException) {
                    throw (HibernateException)exception;
                }
                if (!(exception instanceof SQLException)) throw new HibernateException("error performing isolated work", exception);
                throw this.sqlExceptionHelper().convert((SQLException)exception, "error performing isolated work");
            }
            finally {
                if (bl && bl2) {
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (Exception exception) {
                        LOG.trace("was unable to reset connection back to auto-commit");
                    }
                }
                try {
                    this.jdbcConnectionAccess().releaseConnection(connection);
                }
                catch (Exception exception) {
                    LOG.unableToReleaseIsolatedConnection(exception);
                }
            }
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "unable to obtain isolated JDBC connection");
        }
    }
}

