/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransactionFactory;
import org.hibernate.engine.transaction.internal.jta.CMTTransactionFactory;
import org.hibernate.engine.transaction.internal.jta.JtaTransactionFactory;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionFactoryInitiator<T extends TransactionImplementor>
implements BasicServiceInitiator<TransactionFactory> {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TransactionFactoryInitiator.class.getName());
    public static final TransactionFactoryInitiator INSTANCE = new TransactionFactoryInitiator();

    @Override
    public Class<TransactionFactory> getServiceInitiated() {
        return TransactionFactory.class;
    }

    @Override
    public TransactionFactory initiateService(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        Object v = map.get("hibernate.transaction.factory_class");
        if (TransactionFactory.class.isInstance(v)) {
            return (TransactionFactory)v;
        }
        if (v == null) {
            LOG.usingDefaultTransactionStrategy();
            return new JdbcTransactionFactory();
        }
        String string = this.mapLegacyNames(v.toString());
        LOG.transactionStrategy(string);
        ClassLoaderService classLoaderService = serviceRegistryImplementor.getService(ClassLoaderService.class);
        try {
            return (TransactionFactory)classLoaderService.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("Unable to instantiate specified TransactionFactory class [" + string + "]", exception);
        }
    }

    private String mapLegacyNames(String string) {
        if ("org.hibernate.transaction.JDBCTransactionFactory".equals(string)) {
            return JdbcTransactionFactory.class.getName();
        }
        if ("org.hibernate.transaction.JTATransactionFactory".equals(string)) {
            return JtaTransactionFactory.class.getName();
        }
        if ("org.hibernate.transaction.CMTTransactionFactory".equals(string)) {
            return CMTTransactionFactory.class.getName();
        }
        return string;
    }
}

