/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.ResourceClosedException;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.internal.SynchronizationRegistryImpl;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.spi.JoinStatus;
import org.hibernate.engine.transaction.spi.SynchronizationRegistry;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.engine.transaction.spi.TransactionObserver;
import org.hibernate.engine.transaction.synchronization.internal.RegisteredSynchronization;
import org.hibernate.engine.transaction.synchronization.internal.SynchronizationCallbackCoordinatorImpl;
import org.hibernate.engine.transaction.synchronization.spi.SynchronizationCallbackCoordinator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionCoordinatorImpl
implements TransactionCoordinator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TransactionCoordinatorImpl.class.getName());
    private final transient TransactionContext transactionContext;
    private final transient JdbcCoordinatorImpl jdbcCoordinator;
    private final transient TransactionFactory transactionFactory;
    private final transient TransactionEnvironment transactionEnvironment;
    private final transient List<TransactionObserver> observers;
    private final transient SynchronizationRegistryImpl synchronizationRegistry;
    private transient TransactionImplementor currentHibernateTransaction;
    private transient SynchronizationCallbackCoordinatorImpl callbackCoordinator;
    private transient boolean open = true;
    private transient boolean synchronizationRegistered;
    private transient boolean ownershipTaken;

    public TransactionCoordinatorImpl(Connection connection, TransactionContext transactionContext) {
        boolean bl;
        this.transactionContext = transactionContext;
        this.jdbcCoordinator = new JdbcCoordinatorImpl(connection, (TransactionCoordinator)this);
        this.transactionEnvironment = transactionContext.getTransactionEnvironment();
        this.transactionFactory = this.transactionEnvironment.getTransactionFactory();
        this.observers = new ArrayList<TransactionObserver>();
        this.synchronizationRegistry = new SynchronizationRegistryImpl();
        this.reset();
        boolean bl2 = bl = transactionContext.isAutoCloseSessionEnabled() || transactionContext.isFlushBeforeCompletionEnabled() || transactionContext.getConnectionReleaseMode() == ConnectionReleaseMode.AFTER_TRANSACTION;
        if (bl) {
            this.pulse();
        }
    }

    public TransactionCoordinatorImpl(TransactionContext transactionContext, JdbcCoordinatorImpl jdbcCoordinatorImpl, List<TransactionObserver> list) {
        this.transactionContext = transactionContext;
        this.jdbcCoordinator = jdbcCoordinatorImpl;
        this.transactionEnvironment = transactionContext.getTransactionEnvironment();
        this.transactionFactory = this.transactionEnvironment.getTransactionFactory();
        this.observers = list;
        this.synchronizationRegistry = new SynchronizationRegistryImpl();
        this.reset();
    }

    public void reset() {
        this.synchronizationRegistered = false;
        this.ownershipTaken = false;
        if (this.currentHibernateTransaction != null) {
            this.currentHibernateTransaction.invalidate();
        }
        this.currentHibernateTransaction = this.transactionFactory().createTransaction(this);
        if (this.transactionContext.shouldAutoJoinTransaction()) {
            this.currentHibernateTransaction.markForJoin();
            this.currentHibernateTransaction.join();
        }
        this.synchronizationRegistry.clearSynchronizations();
    }

    @Override
    public void afterTransaction(TransactionImplementor transactionImplementor, int n) {
        LOG.trace("after transaction completion");
        boolean bl = JtaStatusHelper.isCommitted(n);
        if (this.sessionFactory().getStatistics().isStatisticsEnabled()) {
            this.transactionEnvironment.getStatisticsImplementor().endTransaction(bl);
        }
        this.getJdbcCoordinator().afterTransaction();
        this.getTransactionContext().afterTransactionCompletion(transactionImplementor, bl);
        this.sendAfterTransactionCompletionNotifications(transactionImplementor, n);
        this.reset();
    }

    private SessionFactoryImplementor sessionFactory() {
        return this.transactionEnvironment.getSessionFactory();
    }

    @Override
    public boolean isSynchronizationRegistered() {
        return this.synchronizationRegistered;
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.getTransaction().isActive() && this.getTransaction().getJoinStatus() == JoinStatus.JOINED;
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public JdbcCoordinator getJdbcCoordinator() {
        return this.jdbcCoordinator;
    }

    private TransactionFactory transactionFactory() {
        return this.transactionFactory;
    }

    private TransactionEnvironment getTransactionEnvironment() {
        return this.transactionEnvironment;
    }

    @Override
    public TransactionImplementor getTransaction() {
        if (!this.open) {
            throw new ResourceClosedException("This TransactionCoordinator has been closed");
        }
        this.pulse();
        return this.currentHibernateTransaction;
    }

    @Override
    public void afterNonTransactionalQuery(boolean bl) {
        boolean bl2 = this.getJdbcCoordinator().getLogicalConnection().isAutoCommit();
        this.getJdbcCoordinator().afterTransaction();
        if (bl2) {
            for (TransactionObserver transactionObserver : this.observers) {
                transactionObserver.afterCompletion(bl, this.getTransaction());
            }
        }
    }

    @Override
    public void resetJoinStatus() {
        this.getTransaction().resetJoinStatus();
    }

    private void attemptToRegisterJtaSync() {
        if (this.synchronizationRegistered) {
            return;
        }
        if (this.currentHibernateTransaction.isInitiator()) {
            return;
        }
        if (!this.transactionContext.shouldAutoJoinTransaction() && this.currentHibernateTransaction.getJoinStatus() != JoinStatus.MARKED_FOR_JOINED) {
            LOG.debug("Skipping JTA sync registration due to auto join checking");
            return;
        }
        JtaPlatform jtaPlatform = this.getTransactionEnvironment().getJtaPlatform();
        if (jtaPlatform == null) {
            return;
        }
        if (!jtaPlatform.canRegisterSynchronization()) {
            LOG.trace("registered JTA platform says we cannot currently resister synchronization; skipping");
            return;
        }
        if (!this.transactionFactory().isJoinableJtaTransaction(this, this.currentHibernateTransaction)) {
            LOG.trace("TransactionFactory reported no JTA transaction to join; skipping Synchronization registration");
            return;
        }
        jtaPlatform.registerSynchronization(new RegisteredSynchronization(this.getSynchronizationCallbackCoordinator()));
        this.synchronizationRegistered = true;
        LOG.debug("successfully registered Synchronization");
    }

    @Override
    public SynchronizationCallbackCoordinator getSynchronizationCallbackCoordinator() {
        if (this.callbackCoordinator == null) {
            this.callbackCoordinator = new SynchronizationCallbackCoordinatorImpl(this);
        }
        return this.callbackCoordinator;
    }

    @Override
    public void pulse() {
        this.getSynchronizationCallbackCoordinator().pulse();
        if (this.transactionFactory().compatibleWithJtaSynchronization()) {
            this.attemptToRegisterJtaSync();
        }
    }

    @Override
    public Connection close() {
        this.open = false;
        this.reset();
        this.observers.clear();
        return this.jdbcCoordinator.close();
    }

    @Override
    public SynchronizationRegistry getSynchronizationRegistry() {
        return this.synchronizationRegistry;
    }

    @Override
    public void addObserver(TransactionObserver transactionObserver) {
        this.observers.add(transactionObserver);
    }

    @Override
    public void removeObserver(TransactionObserver transactionObserver) {
        this.observers.remove(transactionObserver);
    }

    @Override
    public boolean isTransactionJoinable() {
        return this.transactionFactory().isJoinableJtaTransaction(this, this.currentHibernateTransaction);
    }

    @Override
    public boolean isTransactionJoined() {
        return this.currentHibernateTransaction != null && this.currentHibernateTransaction.getJoinStatus() == JoinStatus.JOINED;
    }

    @Override
    public void setRollbackOnly() {
        this.getTransaction().markRollbackOnly();
    }

    @Override
    public boolean takeOwnership() {
        if (this.ownershipTaken) {
            return false;
        }
        this.ownershipTaken = true;
        return true;
    }

    @Override
    public void sendAfterTransactionBeginNotifications(TransactionImplementor transactionImplementor) {
        for (TransactionObserver transactionObserver : this.observers) {
            transactionObserver.afterBegin(this.currentHibernateTransaction);
        }
    }

    @Override
    public void sendBeforeTransactionCompletionNotifications(TransactionImplementor transactionImplementor) {
        this.synchronizationRegistry.notifySynchronizationsBeforeTransactionCompletion();
        for (TransactionObserver transactionObserver : this.observers) {
            transactionObserver.beforeCompletion(transactionImplementor);
        }
    }

    @Override
    public void sendAfterTransactionCompletionNotifications(TransactionImplementor transactionImplementor, int n) {
        boolean bl = JtaStatusHelper.isCommitted(n);
        for (TransactionObserver transactionObserver : new ArrayList<TransactionObserver>(this.observers)) {
            transactionObserver.afterCompletion(bl, transactionImplementor);
        }
        this.synchronizationRegistry.notifySynchronizationsAfterTransactionCompletion(n);
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        this.jdbcCoordinator.serialize(objectOutputStream);
        objectOutputStream.writeInt(this.observers.size());
        for (TransactionObserver transactionObserver : this.observers) {
            objectOutputStream.writeObject(transactionObserver);
        }
    }

    public static TransactionCoordinatorImpl deserialize(ObjectInputStream objectInputStream, TransactionContext transactionContext) throws ClassNotFoundException, IOException {
        JdbcCoordinatorImpl jdbcCoordinatorImpl = JdbcCoordinatorImpl.deserialize(objectInputStream, transactionContext);
        int n = objectInputStream.readInt();
        List<TransactionObserver> list = CollectionHelper.arrayList(n);
        for (int i = 0; i < n; ++i) {
            list.add((TransactionObserver)objectInputStream.readObject());
        }
        TransactionCoordinatorImpl transactionCoordinatorImpl = new TransactionCoordinatorImpl(transactionContext, jdbcCoordinatorImpl, list);
        jdbcCoordinatorImpl.afterDeserialize(transactionCoordinatorImpl);
        return transactionCoordinatorImpl;
    }
}

