/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal;

import java.util.LinkedHashSet;
import javax.transaction.Synchronization;
import org.hibernate.engine.transaction.internal.NullSynchronizationException;
import org.hibernate.engine.transaction.spi.SynchronizationRegistry;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class SynchronizationRegistryImpl
implements SynchronizationRegistry {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SynchronizationRegistryImpl.class.getName());
    private LinkedHashSet<Synchronization> synchronizations;

    public void registerSynchronization(Synchronization synchronization) {
        boolean bl;
        if (synchronization == null) {
            throw new NullSynchronizationException();
        }
        if (this.synchronizations == null) {
            this.synchronizations = new LinkedHashSet();
        }
        if (!(bl = this.synchronizations.add(synchronization))) {
            LOG.synchronizationAlreadyRegistered(synchronization);
        }
    }

    public void notifySynchronizationsBeforeTransactionCompletion() {
        if (this.synchronizations != null) {
            for (Synchronization synchronization : this.synchronizations) {
                try {
                    synchronization.beforeCompletion();
                }
                catch (Throwable throwable) {
                    LOG.synchronizationFailed(synchronization, throwable);
                }
            }
        }
    }

    public void notifySynchronizationsAfterTransactionCompletion(int n) {
        if (this.synchronizations != null) {
            for (Synchronization synchronization : this.synchronizations) {
                try {
                    synchronization.afterCompletion(n);
                }
                catch (Throwable throwable) {
                    LOG.synchronizationFailed(synchronization, throwable);
                }
            }
        }
    }

    void clearSynchronizations() {
        if (this.synchronizations != null) {
            this.synchronizations.clear();
            this.synchronizations = null;
        }
    }
}

