/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import org.hibernate.MappingException;
import org.hibernate.engine.spi.UnsavedValueStrategy;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class VersionValue
implements UnsavedValueStrategy {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, VersionValue.class.getName());
    private final Object value;
    public static final VersionValue NULL = new VersionValue(){

        public final Boolean isUnsaved(Object object) {
            LOG.trace("Version unsaved-value strategy NULL");
            return object == null;
        }

        public Object getDefaultValue(Object object) {
            return null;
        }

        public String toString() {
            return "VERSION_SAVE_NULL";
        }
    };
    public static final VersionValue UNDEFINED = new VersionValue(){

        public final Boolean isUnsaved(Object object) {
            LOG.trace("Version unsaved-value strategy UNDEFINED");
            return object == null ? Boolean.TRUE : null;
        }

        public Object getDefaultValue(Object object) {
            return object;
        }

        public String toString() {
            return "VERSION_UNDEFINED";
        }
    };
    public static final VersionValue NEGATIVE = new VersionValue(){

        public final Boolean isUnsaved(Object object) throws MappingException {
            LOG.trace("Version unsaved-value strategy NEGATIVE");
            if (object == null) {
                return Boolean.TRUE;
            }
            if (object instanceof Number) {
                return ((Number)object).longValue() < 0L;
            }
            throw new MappingException("unsaved-value NEGATIVE may only be used with short, int and long types");
        }

        public Object getDefaultValue(Object object) {
            return IdentifierGeneratorHelper.getIntegralDataTypeHolder(object.getClass()).initialize(-1L).makeValue();
        }

        public String toString() {
            return "VERSION_NEGATIVE";
        }
    };

    protected VersionValue() {
        this.value = null;
    }

    public VersionValue(Object object) {
        this.value = object;
    }

    public Boolean isUnsaved(Object object) throws MappingException {
        LOG.tracev("Version unsaved-value: {0}", this.value);
        return object == null || object.equals(this.value);
    }

    public Object getDefaultValue(Object object) {
        return this.value;
    }

    public String toString() {
        return "version unsaved-value: " + this.value;
    }
}

