/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.util.EntityPrinter;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryParameters {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, QueryParameters.class.getName());
    private Type[] positionalParameterTypes;
    private Object[] positionalParameterValues;
    private Map<String, TypedValue> namedParameters;
    private LockOptions lockOptions;
    private RowSelection rowSelection;
    private boolean cacheable;
    private String cacheRegion;
    private String comment;
    private ScrollMode scrollMode;
    private Serializable[] collectionKeys;
    private Object optionalObject;
    private String optionalEntityName;
    private Serializable optionalId;
    private boolean isReadOnlyInitialized;
    private boolean readOnly;
    private boolean callable = false;
    private boolean autodiscovertypes = false;
    private boolean isNaturalKeyLookup;
    private final ResultTransformer resultTransformer;
    private String processedSQL;
    private Type[] processedPositionalParameterTypes;
    private Object[] processedPositionalParameterValues;

    public QueryParameters() {
        this(ArrayHelper.EMPTY_TYPE_ARRAY, ArrayHelper.EMPTY_OBJECT_ARRAY);
    }

    public QueryParameters(Type type, Object object) {
        this(new Type[]{type}, new Object[]{object});
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Object object, String string, Serializable serializable) {
        this(typeArray, objectArray);
        this.optionalObject = object;
        this.optionalId = serializable;
        this.optionalEntityName = string;
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray) {
        this(typeArray, objectArray, null, null, false, false, false, null, null, false, null);
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Serializable[] serializableArray) {
        this(typeArray, objectArray, null, serializableArray);
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Map<String, TypedValue> map, Serializable[] serializableArray) {
        this(typeArray, objectArray, map, null, null, false, false, false, null, null, serializableArray, null);
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, LockOptions lockOptions, RowSelection rowSelection, boolean bl, boolean bl2, boolean bl3, String string, String string2, boolean bl4, ResultTransformer resultTransformer) {
        this(typeArray, objectArray, null, lockOptions, rowSelection, bl, bl2, bl3, string, string2, null, resultTransformer);
        this.isNaturalKeyLookup = bl4;
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Map<String, TypedValue> map, LockOptions lockOptions, RowSelection rowSelection, boolean bl, boolean bl2, boolean bl3, String string, String string2, Serializable[] serializableArray, ResultTransformer resultTransformer) {
        this.positionalParameterTypes = typeArray;
        this.positionalParameterValues = objectArray;
        this.namedParameters = map;
        this.lockOptions = lockOptions;
        this.rowSelection = rowSelection;
        this.cacheable = bl3;
        this.cacheRegion = string;
        this.comment = string2;
        this.collectionKeys = serializableArray;
        this.isReadOnlyInitialized = bl;
        this.readOnly = bl2;
        this.resultTransformer = resultTransformer;
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Map<String, TypedValue> map, LockOptions lockOptions, RowSelection rowSelection, boolean bl, boolean bl2, boolean bl3, String string, String string2, Serializable[] serializableArray, Object object, String string3, Serializable serializable, ResultTransformer resultTransformer) {
        this(typeArray, objectArray, map, lockOptions, rowSelection, bl, bl2, bl3, string, string2, serializableArray, resultTransformer);
        this.optionalEntityName = string3;
        this.optionalId = serializable;
        this.optionalObject = object;
    }

    public boolean hasRowSelection() {
        return this.rowSelection != null;
    }

    public Map<String, TypedValue> getNamedParameters() {
        return this.namedParameters;
    }

    public Type[] getPositionalParameterTypes() {
        return this.positionalParameterTypes;
    }

    public Object[] getPositionalParameterValues() {
        return this.positionalParameterValues;
    }

    public RowSelection getRowSelection() {
        return this.rowSelection;
    }

    public ResultTransformer getResultTransformer() {
        return this.resultTransformer;
    }

    public void setNamedParameters(Map<String, TypedValue> map) {
        this.namedParameters = map;
    }

    public void setPositionalParameterTypes(Type[] typeArray) {
        this.positionalParameterTypes = typeArray;
    }

    public void setPositionalParameterValues(Object[] objectArray) {
        this.positionalParameterValues = objectArray;
    }

    public void setRowSelection(RowSelection rowSelection) {
        this.rowSelection = rowSelection;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public void setLockOptions(LockOptions lockOptions) {
        this.lockOptions = lockOptions;
    }

    public void traceParameters(SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        EntityPrinter entityPrinter = new EntityPrinter(sessionFactoryImplementor);
        if (this.positionalParameterValues.length != 0) {
            LOG.tracev("Parameters: {0}", (Object)entityPrinter.toString(this.positionalParameterTypes, this.positionalParameterValues));
        }
        if (this.namedParameters != null) {
            LOG.tracev("Named parameters: {0}", (Object)entityPrinter.toString(this.namedParameters));
        }
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean bl) {
        this.cacheable = bl;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public void setCacheRegion(String string) {
        this.cacheRegion = string;
    }

    public void validateParameters() throws QueryException {
        int n;
        int n2 = this.positionalParameterTypes == null ? 0 : this.positionalParameterTypes.length;
        int n3 = n = this.positionalParameterValues == null ? 0 : this.positionalParameterValues.length;
        if (n2 != n) {
            throw new QueryException("Number of positional parameter types:" + n2 + " does not match number of positional parameters: " + n);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public ScrollMode getScrollMode() {
        return this.scrollMode;
    }

    public void setScrollMode(ScrollMode scrollMode) {
        this.scrollMode = scrollMode;
    }

    public Serializable[] getCollectionKeys() {
        return this.collectionKeys;
    }

    public void setCollectionKeys(Serializable[] serializableArray) {
        this.collectionKeys = serializableArray;
    }

    public String getOptionalEntityName() {
        return this.optionalEntityName;
    }

    public void setOptionalEntityName(String string) {
        this.optionalEntityName = string;
    }

    public Serializable getOptionalId() {
        return this.optionalId;
    }

    public void setOptionalId(Serializable serializable) {
        this.optionalId = serializable;
    }

    public Object getOptionalObject() {
        return this.optionalObject;
    }

    public void setOptionalObject(Object object) {
        this.optionalObject = object;
    }

    public boolean isReadOnlyInitialized() {
        return this.isReadOnlyInitialized;
    }

    public boolean isReadOnly() {
        if (!this.isReadOnlyInitialized()) {
            throw new IllegalStateException("cannot call isReadOnly() when isReadOnlyInitialized() returns false");
        }
        return this.readOnly;
    }

    public boolean isReadOnly(SessionImplementor sessionImplementor) {
        return this.isReadOnlyInitialized ? this.isReadOnly() : sessionImplementor.getPersistenceContext().isDefaultReadOnly();
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        this.isReadOnlyInitialized = true;
    }

    public void setCallable(boolean bl) {
        this.callable = bl;
    }

    public boolean isCallable() {
        return this.callable;
    }

    public boolean hasAutoDiscoverScalarTypes() {
        return this.autodiscovertypes;
    }

    public void processFilters(String string, SessionImplementor sessionImplementor) {
        this.processFilters(string, sessionImplementor.getLoadQueryInfluencers().getEnabledFilters(), sessionImplementor.getFactory());
    }

    public void processFilters(String string, Map map, SessionFactoryImplementor sessionFactoryImplementor) {
        if (map.size() == 0 || !string.contains(":")) {
            this.processedPositionalParameterValues = this.getPositionalParameterValues();
            this.processedPositionalParameterTypes = this.getPositionalParameterTypes();
            this.processedSQL = string;
        } else {
            Dialect dialect = sessionFactoryImplementor.getDialect();
            String string2 = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\" + dialect.openQuote() + dialect.closeQuote();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Type> arrayList2 = new ArrayList<Type>();
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith(":")) {
                    String string4 = string3.substring(1);
                    String[] stringArray = LoadQueryInfluencers.parseFilterParameterName(string4);
                    FilterImpl filterImpl = (FilterImpl)map.get(stringArray[0]);
                    Object object = filterImpl.getParameter(stringArray[1]);
                    Type type = filterImpl.getFilterDefinition().getParameterType(stringArray[1]);
                    if (object != null && Collection.class.isAssignableFrom(object.getClass())) {
                        Iterator iterator = ((Collection)object).iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            stringBuilder.append('?');
                            arrayList.add(e);
                            arrayList2.add(type);
                            if (!iterator.hasNext()) continue;
                            stringBuilder.append(", ");
                        }
                        continue;
                    }
                    stringBuilder.append('?');
                    arrayList.add(object);
                    arrayList2.add(type);
                    continue;
                }
                if ("?".equals(string3) && n < this.getPositionalParameterValues().length) {
                    arrayList.add(this.getPositionalParameterValues()[n]);
                    arrayList2.add(this.getPositionalParameterTypes()[n]);
                    ++n;
                }
                stringBuilder.append(string3);
            }
            this.processedPositionalParameterValues = arrayList.toArray();
            this.processedPositionalParameterTypes = arrayList2.toArray(new Type[arrayList2.size()]);
            this.processedSQL = stringBuilder.toString();
        }
    }

    public String getFilteredSQL() {
        return this.processedSQL;
    }

    public Object[] getFilteredPositionalParameterValues() {
        return this.processedPositionalParameterValues;
    }

    public Type[] getFilteredPositionalParameterTypes() {
        return this.processedPositionalParameterTypes;
    }

    public boolean isNaturalKeyLookup() {
        return this.isNaturalKeyLookup;
    }

    public void setNaturalKeyLookup(boolean bl) {
        this.isNaturalKeyLookup = bl;
    }

    public void setAutoDiscoverScalarTypes(boolean bl) {
        this.autodiscovertypes = bl;
    }

    public QueryParameters createCopyUsing(RowSelection rowSelection) {
        QueryParameters queryParameters = new QueryParameters(this.positionalParameterTypes, this.positionalParameterValues, this.namedParameters, this.lockOptions, rowSelection, this.isReadOnlyInitialized, this.readOnly, this.cacheable, this.cacheRegion, this.comment, this.collectionKeys, this.optionalObject, this.optionalEntityName, this.optionalId, this.resultTransformer);
        queryParameters.processedSQL = this.processedSQL;
        queryParameters.processedPositionalParameterTypes = this.processedPositionalParameterTypes;
        queryParameters.processedPositionalParameterValues = this.processedPositionalParameterValues;
        return queryParameters;
    }
}

