/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import org.hibernate.engine.spi.UnsavedValueStrategy;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class IdentifierValue
implements UnsavedValueStrategy {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, IdentifierValue.class.getName());
    private final Serializable value;
    public static final IdentifierValue ANY = new IdentifierValue(){

        public final Boolean isUnsaved(Object object) {
            LOG.trace("ID unsaved-value strategy ANY");
            return Boolean.TRUE;
        }

        public Serializable getDefaultValue(Object object) {
            return (Serializable)object;
        }

        public String toString() {
            return "SAVE_ANY";
        }
    };
    public static final IdentifierValue NONE = new IdentifierValue(){

        public final Boolean isUnsaved(Object object) {
            LOG.trace("ID unsaved-value strategy NONE");
            return Boolean.FALSE;
        }

        public Serializable getDefaultValue(Object object) {
            return (Serializable)object;
        }

        public String toString() {
            return "SAVE_NONE";
        }
    };
    public static final IdentifierValue NULL = new IdentifierValue(){

        public final Boolean isUnsaved(Object object) {
            LOG.trace("ID unsaved-value strategy NULL");
            return object == null;
        }

        public Serializable getDefaultValue(Object object) {
            return null;
        }

        public String toString() {
            return "SAVE_NULL";
        }
    };
    public static final IdentifierValue UNDEFINED = new IdentifierValue(){

        public final Boolean isUnsaved(Object object) {
            LOG.trace("ID unsaved-value strategy UNDEFINED");
            return null;
        }

        public Serializable getDefaultValue(Object object) {
            return null;
        }

        public String toString() {
            return "UNDEFINED";
        }
    };

    protected IdentifierValue() {
        this.value = null;
    }

    public IdentifierValue(Serializable serializable) {
        this.value = serializable;
    }

    public Boolean isUnsaved(Object object) {
        LOG.tracev("ID unsaved-value: {0}", (Object)this.value);
        return object == null || object.equals(this.value);
    }

    public Serializable getDefaultValue(Object object) {
        return this.value;
    }

    public String toString() {
        return "identifier unsaved-value: " + this.value;
    }
}

