/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;

public final class EntityEntry
implements Serializable {
    private LockMode lockMode;
    private Status status;
    private Status previousStatus;
    private final Serializable id;
    private Object[] loadedState;
    private Object[] deletedState;
    private boolean existsInDatabase;
    private Object version;
    private transient EntityPersister persister;
    private final EntityMode entityMode;
    private final String tenantId;
    private final String entityName;
    private transient EntityKey cachedEntityKey;
    private boolean isBeingReplicated;
    private boolean loadedWithLazyPropertiesUnfetched;
    private final transient Object rowId;
    private final transient PersistenceContext persistenceContext;

    public EntityEntry(Status status, Object[] objectArray, Object object, Serializable serializable, Object object2, LockMode lockMode, boolean bl, EntityPersister entityPersister, EntityMode entityMode, String string, boolean bl2, boolean bl3, PersistenceContext persistenceContext) {
        this.status = status;
        this.previousStatus = null;
        if (status != Status.READ_ONLY) {
            this.loadedState = objectArray;
        }
        this.id = serializable;
        this.rowId = object;
        this.existsInDatabase = bl;
        this.version = object2;
        this.lockMode = lockMode;
        this.isBeingReplicated = bl2;
        this.loadedWithLazyPropertiesUnfetched = bl3;
        this.persister = entityPersister;
        this.entityMode = entityMode;
        this.tenantId = string;
        this.entityName = entityPersister == null ? null : entityPersister.getEntityName();
        this.persistenceContext = persistenceContext;
    }

    private EntityEntry(SessionFactoryImplementor sessionFactoryImplementor, String string, Serializable serializable, EntityMode entityMode, String string2, Status status, Status status2, Object[] objectArray, Object[] objectArray2, Object object, LockMode lockMode, boolean bl, boolean bl2, boolean bl3, PersistenceContext persistenceContext) {
        this.entityName = string;
        this.persister = sessionFactoryImplementor == null ? null : sessionFactoryImplementor.getEntityPersister(string);
        this.id = serializable;
        this.entityMode = entityMode;
        this.tenantId = string2;
        this.status = status;
        this.previousStatus = status2;
        this.loadedState = objectArray;
        this.deletedState = objectArray2;
        this.version = object;
        this.lockMode = lockMode;
        this.existsInDatabase = bl;
        this.isBeingReplicated = bl2;
        this.loadedWithLazyPropertiesUnfetched = bl3;
        this.rowId = null;
        this.persistenceContext = persistenceContext;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        if (status == Status.READ_ONLY) {
            this.loadedState = null;
        }
        if (this.status != status) {
            this.previousStatus = this.status;
            this.status = status;
        }
    }

    public Serializable getId() {
        return this.id;
    }

    public Object[] getLoadedState() {
        return this.loadedState;
    }

    public Object[] getDeletedState() {
        return this.deletedState;
    }

    public void setDeletedState(Object[] objectArray) {
        this.deletedState = objectArray;
    }

    public boolean isExistsInDatabase() {
        return this.existsInDatabase;
    }

    public Object getVersion() {
        return this.version;
    }

    public EntityPersister getPersister() {
        return this.persister;
    }

    public EntityKey getEntityKey() {
        if (this.cachedEntityKey == null) {
            if (this.getId() == null) {
                throw new IllegalStateException("cannot generate an EntityKey when id is null.");
            }
            this.cachedEntityKey = new EntityKey(this.getId(), this.getPersister(), this.tenantId);
        }
        return this.cachedEntityKey;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean isBeingReplicated() {
        return this.isBeingReplicated;
    }

    public Object getRowId() {
        return this.rowId;
    }

    public void postUpdate(Object object, Object[] objectArray, Object object2) {
        FieldInterceptor fieldInterceptor;
        this.loadedState = objectArray;
        this.setLockMode(LockMode.WRITE);
        if (this.getPersister().isVersioned()) {
            this.version = object2;
            this.getPersister().setPropertyValue(object, this.getPersister().getVersionProperty(), object2);
        }
        if (this.getPersister().getInstrumentationMetadata().isInstrumented() && (fieldInterceptor = this.getPersister().getInstrumentationMetadata().extractInterceptor(object)) != null) {
            fieldInterceptor.clearDirty();
        }
        this.persistenceContext.getSession().getFactory().getCustomEntityDirtinessStrategy().resetDirty(object, this.getPersister(), (Session)((Object)this.persistenceContext.getSession()));
    }

    public void postDelete() {
        this.previousStatus = this.status;
        this.status = Status.GONE;
        this.existsInDatabase = false;
    }

    public void postInsert(Object[] objectArray) {
        this.existsInDatabase = true;
    }

    public boolean isNullifiable(boolean bl, SessionImplementor sessionImplementor) {
        return this.getStatus() == Status.SAVING || (bl ? !this.isExistsInDatabase() : sessionImplementor.getPersistenceContext().getNullifiableEntityKeys().contains(this.getEntityKey()));
    }

    public Object getLoadedValue(String string) {
        if (this.loadedState == null) {
            return null;
        }
        int n = ((UniqueKeyLoadable)this.persister).getPropertyIndex(string);
        return this.loadedState[n];
    }

    public boolean requiresDirtyCheck(Object object) {
        return this.isModifiableEntity() && !this.isUnequivocallyNonDirty(object);
    }

    private boolean isUnequivocallyNonDirty(Object object) {
        CustomEntityDirtinessStrategy customEntityDirtinessStrategy = this.persistenceContext.getSession().getFactory().getCustomEntityDirtinessStrategy();
        if (customEntityDirtinessStrategy.canDirtyCheck(object, this.getPersister(), (Session)((Object)this.persistenceContext.getSession()))) {
            return !customEntityDirtinessStrategy.isDirty(object, this.getPersister(), (Session)((Object)this.persistenceContext.getSession()));
        }
        if (this.getPersister().hasMutableProperties()) {
            return false;
        }
        if (this.getPersister().getInstrumentationMetadata().isInstrumented()) {
            return !this.getPersister().getInstrumentationMetadata().extractInterceptor(object).isDirty();
        }
        return false;
    }

    public boolean isModifiableEntity() {
        return this.getPersister().isMutable() && this.status != Status.READ_ONLY && (this.status != Status.DELETED || this.previousStatus != Status.READ_ONLY);
    }

    public void forceLocked(Object object, Object object2) {
        this.loadedState[this.persister.getVersionProperty()] = this.version = object2;
        this.setLockMode(LockMode.FORCE);
        this.persister.setPropertyValue(object, this.getPersister().getVersionProperty(), object2);
    }

    public boolean isReadOnly() {
        if (this.status != Status.MANAGED && this.status != Status.READ_ONLY) {
            throw new HibernateException("instance was not in a valid state");
        }
        return this.status == Status.READ_ONLY;
    }

    public void setReadOnly(boolean bl, Object object) {
        if (bl == this.isReadOnly()) {
            return;
        }
        if (bl) {
            this.setStatus(Status.READ_ONLY);
            this.loadedState = null;
        } else {
            if (!this.persister.isMutable()) {
                throw new IllegalStateException("Cannot make an immutable entity modifiable.");
            }
            this.setStatus(Status.MANAGED);
            this.loadedState = this.getPersister().getPropertyValues(object);
            this.persistenceContext.getNaturalIdHelper().manageLocalNaturalIdCrossReference(this.persister, this.id, this.loadedState, null, CachedNaturalIdValueSource.LOAD);
        }
    }

    public String toString() {
        return "EntityEntry" + MessageHelper.infoString(this.entityName, this.id) + '(' + (Object)((Object)this.status) + ')';
    }

    public boolean isLoadedWithLazyPropertiesUnfetched() {
        return this.loadedWithLazyPropertiesUnfetched;
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.entityName);
        objectOutputStream.writeObject(this.id);
        objectOutputStream.writeObject(this.entityMode.toString());
        objectOutputStream.writeObject(this.tenantId);
        objectOutputStream.writeObject(this.status.name());
        objectOutputStream.writeObject(this.previousStatus == null ? "" : this.previousStatus.name());
        objectOutputStream.writeObject(this.loadedState);
        objectOutputStream.writeObject(this.deletedState);
        objectOutputStream.writeObject(this.version);
        objectOutputStream.writeObject(this.lockMode.toString());
        objectOutputStream.writeBoolean(this.existsInDatabase);
        objectOutputStream.writeBoolean(this.isBeingReplicated);
        objectOutputStream.writeBoolean(this.loadedWithLazyPropertiesUnfetched);
    }

    public static EntityEntry deserialize(ObjectInputStream objectInputStream, PersistenceContext persistenceContext) throws IOException, ClassNotFoundException {
        String string = (String)objectInputStream.readObject();
        return new EntityEntry(persistenceContext.getSession() == null ? null : persistenceContext.getSession().getFactory(), (String)objectInputStream.readObject(), (Serializable)objectInputStream.readObject(), EntityMode.parse((String)objectInputStream.readObject()), (String)objectInputStream.readObject(), Status.valueOf((String)objectInputStream.readObject()), string.length() == 0 ? null : Status.valueOf(string), (Object[])objectInputStream.readObject(), (Object[])objectInputStream.readObject(), objectInputStream.readObject(), LockMode.valueOf((String)objectInputStream.readObject()), objectInputStream.readBoolean(), objectInputStream.readBoolean(), objectInputStream.readBoolean(), persistenceContext);
    }
}

