/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ReplicationMode;
import org.hibernate.TransientPropertyValueException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class CascadingAction {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, CascadingAction.class.getName());
    public static final CascadingAction DELETE = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            LOG.tracev("Cascading to delete: {0}", (Object)string);
            eventSource.delete(string, object, bl, (Set)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return CascadingAction.getAllElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public String toString() {
            return "ACTION_DELETE";
        }
    };
    public static final CascadingAction LOCK = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            LOG.tracev("Cascading to lock: {0}", (Object)string);
            LockMode lockMode = LockMode.NONE;
            LockOptions lockOptions = new LockOptions();
            if (object2 instanceof LockOptions) {
                LockOptions lockOptions2 = (LockOptions)object2;
                lockOptions.setTimeOut(lockOptions2.getTimeOut());
                lockOptions.setScope(lockOptions2.getScope());
                if (lockOptions2.getScope()) {
                    lockMode = lockOptions2.getLockMode();
                }
            }
            lockOptions.setLockMode(lockMode);
            eventSource.buildLockRequest(lockOptions).lock(string, object);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 2.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_LOCK";
        }
    };
    public static final CascadingAction REFRESH = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            LOG.tracev("Cascading to refresh: {0}", (Object)string);
            eventSource.refresh(object, (Map)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 3.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REFRESH";
        }
    };
    public static final CascadingAction EVICT = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            LOG.tracev("Cascading to evict: {0}", (Object)string);
            eventSource.evict(object);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 4.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_EVICT";
        }
    };
    public static final CascadingAction SAVE_UPDATE = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            LOG.tracev("Cascading to save or update: {0}", (Object)string);
            eventSource.saveOrUpdate(string, object);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 5.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_SAVE_UPDATE";
        }
    };
    public static final CascadingAction MERGE = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            LOG.tracev("Cascading to merge: {0}", (Object)string);
            eventSource.merge(string, object, (Map)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 6.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_MERGE";
        }
    };
    public static final CascadingAction PERSIST = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            LOG.tracev("Cascading to persist: {0}" + string, new Object[0]);
            eventSource.persist(string, object, (Map)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return CascadingAction.getAllElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_PERSIST";
        }
    };
    public static final CascadingAction PERSIST_ON_FLUSH = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            LOG.tracev("Cascading to persist on flush: {0}", (Object)string);
            eventSource.persistOnFlush(string, object, (Map)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return CascadingAction.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public boolean requiresNoCascadeChecking() {
            return true;
        }

        public void noCascade(EventSource eventSource, Object object, Object object2, EntityPersister entityPersister, int n) {
            if (object == null) {
                return;
            }
            Type type = entityPersister.getPropertyTypes()[n];
            if (type.isEntityType()) {
                String string = ((EntityType)type).getAssociatedEntityName(eventSource.getFactory());
                if (!this.isInManagedState(object, eventSource) && !(object instanceof HibernateProxy) && ForeignKeys.isTransient(string, object, null, eventSource)) {
                    String string2 = entityPersister.getEntityName();
                    String string3 = entityPersister.getPropertyNames()[n];
                    throw new TransientPropertyValueException("object references an unsaved transient instance - save the transient instance before flushing", string, string2, string3);
                }
            }
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        private boolean isInManagedState(Object object, EventSource eventSource) {
            EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
            return entityEntry != null && (entityEntry.getStatus() == Status.MANAGED || entityEntry.getStatus() == Status.READ_ONLY || entityEntry.getStatus() == Status.SAVING);
        }

        public String toString() {
            return "ACTION_PERSIST_ON_FLUSH";
        }
    };
    public static final CascadingAction REPLICATE = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            LOG.tracev("Cascading to replicate: {0}", (Object)string);
            eventSource.replicate(string, object, (ReplicationMode)((Object)object2));
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 9.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REPLICATE";
        }
    };

    public abstract void cascade(EventSource var1, Object var2, String var3, Object var4, boolean var5) throws HibernateException;

    public abstract Iterator getCascadableChildrenIterator(EventSource var1, CollectionType var2, Object var3);

    public abstract boolean deleteOrphans();

    public boolean requiresNoCascadeChecking() {
        return false;
    }

    public void noCascade(EventSource eventSource, Object object, Object object2, EntityPersister entityPersister, int n) {
    }

    public boolean performOnLazyProperty() {
        return true;
    }

    private static Iterator getAllElementsIterator(EventSource eventSource, CollectionType collectionType, Object object) {
        return collectionType.getElementsIterator(object, eventSource);
    }

    public static Iterator getLoadedElementsIterator(SessionImplementor sessionImplementor, CollectionType collectionType, Object object) {
        if (CascadingAction.collectionIsInitialized(object)) {
            return collectionType.getElementsIterator(object, sessionImplementor);
        }
        return ((PersistentCollection)object).queuedAdditionIterator();
    }

    private static boolean collectionIsInitialized(Object object) {
        return !(object instanceof PersistentCollection) || ((PersistentCollection)object).wasInitialized();
    }
}

