/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class BatchFetchQueue {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, BatchFetchQueue.class.getName());
    private final PersistenceContext context;
    private final Map<EntityKey, SubselectFetch> subselectsByEntityKey = new HashMap<EntityKey, SubselectFetch>(8);
    private final Map<String, LinkedHashSet<EntityKey>> batchLoadableEntityKeys = new HashMap<String, LinkedHashSet<EntityKey>>(8);
    private final Map<String, LinkedHashMap<CollectionEntry, PersistentCollection>> batchLoadableCollections = new HashMap<String, LinkedHashMap<CollectionEntry, PersistentCollection>>(8);

    public BatchFetchQueue(PersistenceContext persistenceContext) {
        this.context = persistenceContext;
    }

    public void clear() {
        this.batchLoadableEntityKeys.clear();
        this.batchLoadableCollections.clear();
        this.subselectsByEntityKey.clear();
    }

    public SubselectFetch getSubselect(EntityKey entityKey) {
        return this.subselectsByEntityKey.get(entityKey);
    }

    public void addSubselect(EntityKey entityKey, SubselectFetch subselectFetch) {
        this.subselectsByEntityKey.put(entityKey, subselectFetch);
    }

    public void removeSubselect(EntityKey entityKey) {
        this.subselectsByEntityKey.remove(entityKey);
    }

    public void addBatchLoadableEntityKey(EntityKey entityKey) {
        if (entityKey.isBatchLoadable()) {
            LinkedHashSet<EntityKey> linkedHashSet = this.batchLoadableEntityKeys.get(entityKey.getEntityName());
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet(8);
                this.batchLoadableEntityKeys.put(entityKey.getEntityName(), linkedHashSet);
            }
            linkedHashSet.add(entityKey);
        }
    }

    public void removeBatchLoadableEntityKey(EntityKey entityKey) {
        LinkedHashSet<EntityKey> linkedHashSet;
        if (entityKey.isBatchLoadable() && (linkedHashSet = this.batchLoadableEntityKeys.get(entityKey.getEntityName())) != null) {
            linkedHashSet.remove(entityKey);
        }
    }

    public Serializable[] getEntityBatch(EntityPersister entityPersister, Serializable serializable, int n, EntityMode entityMode) {
        Serializable[] serializableArray = new Serializable[n];
        serializableArray[0] = serializable;
        int n2 = 1;
        int n3 = -1;
        boolean bl = false;
        LinkedHashSet<EntityKey> linkedHashSet = this.batchLoadableEntityKeys.get(entityPersister.getEntityName());
        if (linkedHashSet != null) {
            for (EntityKey entityKey : linkedHashSet) {
                if (bl && n2 == n3) {
                    return serializableArray;
                }
                if (entityPersister.getIdentifierType().isEqual(serializable, entityKey.getIdentifier())) {
                    n3 = n2;
                } else if (!this.isCached(entityKey, entityPersister)) {
                    serializableArray[n2++] = entityKey.getIdentifier();
                }
                if (n2 != n) continue;
                n2 = 1;
                if (n3 == -1) continue;
                bl = true;
            }
        }
        return serializableArray;
    }

    private boolean isCached(EntityKey entityKey, EntityPersister entityPersister) {
        if (entityPersister.hasCache()) {
            CacheKey cacheKey = this.context.getSession().generateCacheKey(entityKey.getIdentifier(), entityPersister.getIdentifierType(), entityKey.getEntityName());
            return entityPersister.getCacheAccessStrategy().get(cacheKey, this.context.getSession().getTimestamp()) != null;
        }
        return false;
    }

    public void addBatchLoadableCollection(PersistentCollection persistentCollection, CollectionEntry collectionEntry) {
        CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
        LinkedHashMap<CollectionEntry, PersistentCollection> linkedHashMap = this.batchLoadableCollections.get(collectionPersister.getRole());
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap(16);
            this.batchLoadableCollections.put(collectionPersister.getRole(), linkedHashMap);
        }
        linkedHashMap.put(collectionEntry, persistentCollection);
    }

    public void removeBatchLoadableCollection(CollectionEntry collectionEntry) {
        LinkedHashMap<CollectionEntry, PersistentCollection> linkedHashMap = this.batchLoadableCollections.get(collectionEntry.getLoadedPersister().getRole());
        if (linkedHashMap != null) {
            linkedHashMap.remove(collectionEntry);
        }
    }

    public Serializable[] getCollectionBatch(CollectionPersister collectionPersister, Serializable serializable, int n) {
        Serializable[] serializableArray = new Serializable[n];
        serializableArray[0] = serializable;
        int n2 = 1;
        int n3 = -1;
        boolean bl = false;
        LinkedHashMap<CollectionEntry, PersistentCollection> linkedHashMap = this.batchLoadableCollections.get(collectionPersister.getRole());
        if (linkedHashMap != null) {
            for (Map.Entry<CollectionEntry, PersistentCollection> entry : linkedHashMap.entrySet()) {
                CollectionEntry collectionEntry = entry.getKey();
                PersistentCollection persistentCollection = entry.getValue();
                if (collectionEntry.getLoadedKey() == null) continue;
                if (persistentCollection.wasInitialized()) {
                    LOG.warn("Encountered initialized collection in BatchFetchQueue, this should not happen.");
                    continue;
                }
                if (bl && n2 == n3) {
                    return serializableArray;
                }
                boolean bl2 = collectionPersister.getKeyType().isEqual(serializable, collectionEntry.getLoadedKey(), collectionPersister.getFactory());
                if (bl2) {
                    n3 = n2;
                } else if (!this.isCached(collectionEntry.getLoadedKey(), collectionPersister)) {
                    serializableArray[n2++] = collectionEntry.getLoadedKey();
                }
                if (n2 != n) continue;
                n2 = 1;
                if (n3 == -1) continue;
                bl = true;
            }
        }
        return serializableArray;
    }

    private boolean isCached(Serializable serializable, CollectionPersister collectionPersister) {
        if (collectionPersister.hasCache()) {
            CacheKey cacheKey = this.context.getSession().generateCacheKey(serializable, collectionPersister.getKeyType(), collectionPersister.getRole());
            return collectionPersister.getCacheAccessStrategy().get(cacheKey, this.context.getSession().getTimestamp()) != null;
        }
        return false;
    }
}

