/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.PropertyValueException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.action.internal.CollectionRecreateAction;
import org.hibernate.action.internal.CollectionRemoveAction;
import org.hibernate.action.internal.CollectionUpdateAction;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.action.internal.EntityDeleteAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.action.internal.QueuedOperationCollectionAction;
import org.hibernate.action.internal.UnresolvedEntityInsertActions;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class ActionQueue {
    static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ActionQueue.class.getName());
    private static final int INIT_QUEUE_LIST_SIZE = 5;
    private SessionImplementor session;
    private UnresolvedEntityInsertActions unresolvedInsertions;
    private ArrayList insertions;
    private ArrayList<EntityDeleteAction> deletions;
    private ArrayList updates;
    private ArrayList collectionCreations;
    private ArrayList collectionUpdates;
    private ArrayList collectionQueuedOps;
    private ArrayList collectionRemovals;
    private AfterTransactionCompletionProcessQueue afterTransactionProcesses;
    private BeforeTransactionCompletionProcessQueue beforeTransactionProcesses;

    public ActionQueue(SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
        this.init();
    }

    private void init() {
        this.unresolvedInsertions = new UnresolvedEntityInsertActions();
        this.insertions = new ArrayList(5);
        this.deletions = new ArrayList(5);
        this.updates = new ArrayList(5);
        this.collectionCreations = new ArrayList(5);
        this.collectionRemovals = new ArrayList(5);
        this.collectionUpdates = new ArrayList(5);
        this.collectionQueuedOps = new ArrayList(5);
        this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
        this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
    }

    public void clear() {
        this.updates.clear();
        this.insertions.clear();
        this.deletions.clear();
        this.collectionCreations.clear();
        this.collectionRemovals.clear();
        this.collectionUpdates.clear();
        this.collectionQueuedOps.clear();
        this.unresolvedInsertions.clear();
    }

    public void addAction(EntityInsertAction entityInsertAction) {
        LOG.tracev("Adding an EntityInsertAction for [{0}] object", (Object)entityInsertAction.getEntityName());
        this.addInsertAction(entityInsertAction);
    }

    public void addAction(EntityDeleteAction entityDeleteAction) {
        this.deletions.add(entityDeleteAction);
    }

    public void addAction(EntityUpdateAction entityUpdateAction) {
        this.updates.add(entityUpdateAction);
    }

    public void addAction(CollectionRecreateAction collectionRecreateAction) {
        this.collectionCreations.add(collectionRecreateAction);
    }

    public void addAction(CollectionRemoveAction collectionRemoveAction) {
        this.collectionRemovals.add(collectionRemoveAction);
    }

    public void addAction(CollectionUpdateAction collectionUpdateAction) {
        this.collectionUpdates.add(collectionUpdateAction);
    }

    public void addAction(QueuedOperationCollectionAction queuedOperationCollectionAction) {
        this.collectionQueuedOps.add(queuedOperationCollectionAction);
    }

    public void addAction(EntityIdentityInsertAction entityIdentityInsertAction) {
        LOG.tracev("Adding an EntityIdentityInsertAction for [{0}] object", (Object)entityIdentityInsertAction.getEntityName());
        this.addInsertAction(entityIdentityInsertAction);
    }

    private void addInsertAction(AbstractEntityInsertAction abstractEntityInsertAction) {
        NonNullableTransientDependencies nonNullableTransientDependencies;
        if (abstractEntityInsertAction.isEarlyInsert()) {
            LOG.tracev("Executing inserts before finding non-nullable transient entities for early insert: [{0}]", (Object)abstractEntityInsertAction);
            this.executeInserts();
        }
        if ((nonNullableTransientDependencies = abstractEntityInsertAction.findNonNullableTransientEntities()) == null) {
            LOG.tracev("Adding insert with no non-nullable, transient entities: [{0}]", (Object)abstractEntityInsertAction);
            this.addResolvedEntityInsertAction(abstractEntityInsertAction);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Adding insert with non-nullable, transient entities; insert=[{0}], dependencies=[{1}]", (Object)abstractEntityInsertAction, (Object)nonNullableTransientDependencies.toLoggableString(abstractEntityInsertAction.getSession()));
            }
            this.unresolvedInsertions.addUnresolvedEntityInsertAction(abstractEntityInsertAction, nonNullableTransientDependencies);
        }
    }

    private void addResolvedEntityInsertAction(AbstractEntityInsertAction abstractEntityInsertAction) {
        if (abstractEntityInsertAction.isEarlyInsert()) {
            LOG.trace("Executing insertions before resolved early-insert");
            this.executeInserts();
            LOG.debug("Executing identity-insert immediately");
            this.execute(abstractEntityInsertAction);
        } else {
            LOG.trace("Adding resolved non-early insert action.");
            this.insertions.add(abstractEntityInsertAction);
        }
        abstractEntityInsertAction.makeEntityManaged();
        for (AbstractEntityInsertAction abstractEntityInsertAction2 : this.unresolvedInsertions.resolveDependentActions(abstractEntityInsertAction.getInstance(), this.session)) {
            this.addResolvedEntityInsertAction(abstractEntityInsertAction2);
        }
    }

    public boolean hasUnresolvedEntityInsertActions() {
        return !this.unresolvedInsertions.isEmpty();
    }

    public void checkNoUnresolvedActionsAfterOperation() throws PropertyValueException {
        this.unresolvedInsertions.checkNoUnresolvedActionsAfterOperation();
    }

    public void addAction(BulkOperationCleanupAction bulkOperationCleanupAction) {
        this.registerCleanupActions(bulkOperationCleanupAction);
    }

    public void registerProcess(AfterTransactionCompletionProcess afterTransactionCompletionProcess) {
        this.afterTransactionProcesses.register(afterTransactionCompletionProcess);
    }

    public void registerProcess(BeforeTransactionCompletionProcess beforeTransactionCompletionProcess) {
        this.beforeTransactionProcesses.register(beforeTransactionCompletionProcess);
    }

    public void executeInserts() throws HibernateException {
        this.executeActions(this.insertions);
    }

    public void executeActions() throws HibernateException {
        if (!this.unresolvedInsertions.isEmpty()) {
            throw new IllegalStateException("About to execute actions, but there are unresolved entity insert actions.");
        }
        this.executeActions(this.insertions);
        this.executeActions(this.updates);
        this.executeActions(this.collectionQueuedOps);
        this.executeActions(this.collectionRemovals);
        this.executeActions(this.collectionUpdates);
        this.executeActions(this.collectionCreations);
        this.executeActions(this.deletions);
    }

    public void prepareActions() throws HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
        this.prepareActions(this.collectionQueuedOps);
    }

    public void afterTransactionCompletion(boolean bl) {
        this.afterTransactionProcesses.afterTransactionCompletion(bl);
    }

    public void beforeTransactionCompletion() {
        this.beforeTransactionProcesses.beforeTransactionCompletion();
    }

    public boolean areTablesToBeUpdated(Set set) {
        return ActionQueue.areTablesToUpdated(this.updates, set) || ActionQueue.areTablesToUpdated(this.insertions, set) || ActionQueue.areTablesToUpdated(this.unresolvedInsertions.getDependentEntityInsertActions(), set) || ActionQueue.areTablesToUpdated(this.deletions, set) || ActionQueue.areTablesToUpdated(this.collectionUpdates, set) || ActionQueue.areTablesToUpdated(this.collectionCreations, set) || ActionQueue.areTablesToUpdated(this.collectionQueuedOps, set) || ActionQueue.areTablesToUpdated(this.collectionRemovals, set);
    }

    public boolean areInsertionsOrDeletionsQueued() {
        return this.insertions.size() > 0 || !this.unresolvedInsertions.isEmpty() || this.deletions.size() > 0;
    }

    private static boolean areTablesToUpdated(Iterable iterable, Set set) {
        for (Executable executable : iterable) {
            Serializable[] serializableArray;
            for (Serializable serializable : serializableArray = executable.getPropertySpaces()) {
                if (!set.contains(serializable)) continue;
                LOG.debugf("Changes must be flushed to space: %s", (Object)serializable);
                return true;
            }
        }
        return false;
    }

    private void executeActions(List list) throws HibernateException {
        for (Object e : list) {
            this.execute((Executable)e);
        }
        list.clear();
        this.session.getTransactionCoordinator().getJdbcCoordinator().executeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Executable executable) {
        try {
            executable.execute();
        }
        finally {
            this.registerCleanupActions(executable);
        }
    }

    private void registerCleanupActions(Executable executable) {
        String[] stringArray;
        this.beforeTransactionProcesses.register(executable.getBeforeTransactionCompletionProcess());
        if (this.session.getFactory().getSettings().isQueryCacheEnabled() && (stringArray = (String[])executable.getPropertySpaces()) != null && stringArray.length > 0) {
            this.afterTransactionProcesses.addSpacesToInvalidate(stringArray);
            this.session.getFactory().getUpdateTimestampsCache().preinvalidate((Serializable[])stringArray);
        }
        this.afterTransactionProcesses.register(executable.getAfterTransactionCompletionProcess());
    }

    private void prepareActions(List list) throws HibernateException {
        for (Executable executable : list) {
            executable.beforeExecutions();
        }
    }

    public String toString() {
        return "ActionQueue[insertions=" + this.insertions + " updates=" + this.updates + " deletions=" + this.deletions + " collectionCreations=" + this.collectionCreations + " collectionRemovals=" + this.collectionRemovals + " collectionUpdates=" + this.collectionUpdates + " collectionQueuedOps=" + this.collectionQueuedOps + " unresolvedInsertDependencies=" + this.unresolvedInsertions + "]";
    }

    public int numberOfCollectionRemovals() {
        return this.collectionRemovals.size();
    }

    public int numberOfCollectionUpdates() {
        return this.collectionUpdates.size();
    }

    public int numberOfCollectionCreations() {
        return this.collectionCreations.size();
    }

    public int numberOfDeletions() {
        return this.deletions.size();
    }

    public int numberOfUpdates() {
        return this.updates.size();
    }

    public int numberOfInsertions() {
        return this.insertions.size();
    }

    public void sortCollectionActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.collectionCreations);
            Collections.sort(this.collectionUpdates);
            Collections.sort(this.collectionQueuedOps);
            Collections.sort(this.collectionRemovals);
        }
    }

    public void sortActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.updates);
        }
        if (this.session.getFactory().getSettings().isOrderInsertsEnabled()) {
            this.sortInsertActions();
        }
    }

    private void sortInsertActions() {
        new InsertActionSorter().sort();
    }

    public ArrayList cloneDeletions() {
        return (ArrayList)this.deletions.clone();
    }

    public void clearFromFlushNeededCheck(int n) {
        this.collectionCreations.clear();
        this.collectionUpdates.clear();
        this.collectionQueuedOps.clear();
        this.updates.clear();
        for (int i = this.collectionRemovals.size() - 1; i >= n; --i) {
            this.collectionRemovals.remove(i);
        }
    }

    public boolean hasAfterTransactionActions() {
        return this.afterTransactionProcesses.processes.size() > 0;
    }

    public boolean hasBeforeTransactionActions() {
        return this.beforeTransactionProcesses.processes.size() > 0;
    }

    public boolean hasAnyQueuedActions() {
        return this.updates.size() > 0 || this.insertions.size() > 0 || !this.unresolvedInsertions.isEmpty() || this.deletions.size() > 0 || this.collectionUpdates.size() > 0 || this.collectionQueuedOps.size() > 0 || this.collectionRemovals.size() > 0 || this.collectionCreations.size() > 0;
    }

    public void unScheduleDeletion(EntityEntry entityEntry, Object object) {
        for (int i = 0; i < this.deletions.size(); ++i) {
            EntityDeleteAction entityDeleteAction = this.deletions.get(i);
            if (entityDeleteAction.getInstance() != object) continue;
            this.deletions.remove(i);
            return;
        }
        throw new AssertionFailure("Unable to perform un-delete for instance " + entityEntry.getEntityName());
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        LOG.trace("Serializing action-queue");
        this.unresolvedInsertions.serialize(objectOutputStream);
        int n2 = this.insertions.size();
        LOG.tracev("Starting serialization of [{0}] insertions entries", (Object)n2);
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.insertions.get(n));
        }
        n2 = this.deletions.size();
        LOG.tracev("Starting serialization of [{0}] deletions entries", (Object)n2);
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.deletions.get(n));
        }
        n2 = this.updates.size();
        LOG.tracev("Starting serialization of [{0}] updates entries", (Object)n2);
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.updates.get(n));
        }
        n2 = this.collectionUpdates.size();
        LOG.tracev("Starting serialization of [{0}] collectionUpdates entries", (Object)n2);
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.collectionUpdates.get(n));
        }
        n2 = this.collectionRemovals.size();
        LOG.tracev("Starting serialization of [{0}] collectionRemovals entries", (Object)n2);
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.collectionRemovals.get(n));
        }
        n2 = this.collectionCreations.size();
        LOG.tracev("Starting serialization of [{0}] collectionCreations entries", (Object)n2);
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.collectionCreations.get(n));
        }
        n2 = this.collectionQueuedOps.size();
        LOG.tracev("Starting serialization of [{0}] collectionQueuedOps entries", (Object)n2);
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.collectionQueuedOps.get(n));
        }
    }

    public static ActionQueue deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        Comparable comparable;
        int n;
        LOG.trace("Dedeserializing action-queue");
        ActionQueue actionQueue = new ActionQueue(sessionImplementor);
        actionQueue.unresolvedInsertions = UnresolvedEntityInsertActions.deserialize(objectInputStream, sessionImplementor);
        int n2 = objectInputStream.readInt();
        LOG.tracev("Starting deserialization of [{0}] insertions entries", (Object)n2);
        actionQueue.insertions = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            comparable = (EntityAction)objectInputStream.readObject();
            ((EntityAction)comparable).afterDeserialize(sessionImplementor);
            actionQueue.insertions.add(comparable);
        }
        n2 = objectInputStream.readInt();
        LOG.tracev("Starting deserialization of [{0}] deletions entries", (Object)n2);
        actionQueue.deletions = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            comparable = (EntityDeleteAction)objectInputStream.readObject();
            ((EntityAction)comparable).afterDeserialize(sessionImplementor);
            actionQueue.deletions.add((EntityDeleteAction)comparable);
        }
        n2 = objectInputStream.readInt();
        LOG.tracev("Starting deserialization of [{0}] updates entries", (Object)n2);
        actionQueue.updates = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            comparable = (EntityAction)objectInputStream.readObject();
            ((EntityAction)comparable).afterDeserialize(sessionImplementor);
            actionQueue.updates.add(comparable);
        }
        n2 = objectInputStream.readInt();
        LOG.tracev("Starting deserialization of [{0}] collectionUpdates entries", (Object)n2);
        actionQueue.collectionUpdates = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            comparable = (CollectionAction)objectInputStream.readObject();
            ((CollectionAction)comparable).afterDeserialize(sessionImplementor);
            actionQueue.collectionUpdates.add(comparable);
        }
        n2 = objectInputStream.readInt();
        LOG.tracev("Starting deserialization of [{0}] collectionRemovals entries", (Object)n2);
        actionQueue.collectionRemovals = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            comparable = (CollectionAction)objectInputStream.readObject();
            ((CollectionAction)comparable).afterDeserialize(sessionImplementor);
            actionQueue.collectionRemovals.add(comparable);
        }
        n2 = objectInputStream.readInt();
        LOG.tracev("Starting deserialization of [{0}] collectionCreations entries", (Object)n2);
        actionQueue.collectionCreations = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            comparable = (CollectionAction)objectInputStream.readObject();
            ((CollectionAction)comparable).afterDeserialize(sessionImplementor);
            actionQueue.collectionCreations.add(comparable);
        }
        n2 = objectInputStream.readInt();
        LOG.tracev("Starting deserialization of [{0}] collectionQueuedOps entries", (Object)n2);
        actionQueue.collectionQueuedOps = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            comparable = (CollectionAction)objectInputStream.readObject();
            ((CollectionAction)comparable).afterDeserialize(sessionImplementor);
            actionQueue.collectionQueuedOps.add(comparable);
        }
        return actionQueue;
    }

    private class InsertActionSorter {
        private HashMap<String, Integer> latestBatches = new HashMap();
        private HashMap<Object, Integer> entityBatchNumber;
        private HashMap<Integer, List<EntityInsertAction>> actionBatches = new HashMap();

        public InsertActionSorter() {
            this.entityBatchNumber = new HashMap(ActionQueue.this.insertions.size() + 1, 1.0f);
        }

        public void sort() {
            Object object;
            Object object2;
            for (Object object3 : ActionQueue.this.insertions) {
                Integer n;
                object2 = ((EntityAction)object3).getEntityName();
                object = ((EntityAction)object3).getInstance();
                if (this.latestBatches.containsKey(object2)) {
                    n = this.findBatchNumber((EntityInsertAction)object3, (String)object2);
                } else {
                    n = this.actionBatches.size();
                    this.latestBatches.put((String)object2, n);
                }
                this.entityBatchNumber.put(object, n);
                this.addToBatch(n, (EntityInsertAction)object3);
            }
            ActionQueue.this.insertions.clear();
            for (int i = 0; i < this.actionBatches.size(); ++i) {
                Object object3;
                object3 = this.actionBatches.get(i);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (EntityInsertAction)object2.next();
                    ActionQueue.this.insertions.add(object);
                }
            }
        }

        private Integer findBatchNumber(EntityInsertAction entityInsertAction, String string) {
            Integer n = this.latestBatches.get(string);
            Object[] objectArray = entityInsertAction.getState();
            Type[] typeArray = entityInsertAction.getPersister().getClassMetadata().getPropertyTypes();
            for (int i = 0; i < objectArray.length; ++i) {
                Integer n2;
                Object object = objectArray[i];
                Type type = typeArray[i];
                if (!type.isEntityType() || object == null || (n2 = this.entityBatchNumber.get(object)) == null || n2.compareTo(n) <= 0) continue;
                n = this.actionBatches.size();
                this.latestBatches.put(string, n);
                break;
            }
            return n;
        }

        private void addToBatch(Integer n, EntityInsertAction entityInsertAction) {
            List<EntityInsertAction> list = this.actionBatches.get(n);
            if (list == null) {
                list = new LinkedList<EntityInsertAction>();
                this.actionBatches.put(n, list);
            }
            list.add(entityInsertAction);
        }
    }

    private static class AfterTransactionCompletionProcessQueue {
        private SessionImplementor session;
        private Set<String> querySpacesToInvalidate = new HashSet<String>();
        private Queue<AfterTransactionCompletionProcess> processes = new ConcurrentLinkedQueue<AfterTransactionCompletionProcess>();

        private AfterTransactionCompletionProcessQueue(SessionImplementor sessionImplementor) {
            this.session = sessionImplementor;
        }

        public void addSpacesToInvalidate(String[] stringArray) {
            for (String string : stringArray) {
                this.addSpaceToInvalidate(string);
            }
        }

        public void addSpaceToInvalidate(String string) {
            this.querySpacesToInvalidate.add(string);
        }

        public void register(AfterTransactionCompletionProcess afterTransactionCompletionProcess) {
            if (afterTransactionCompletionProcess == null) {
                return;
            }
            this.processes.add(afterTransactionCompletionProcess);
        }

        public void afterTransactionCompletion(boolean bl) {
            for (AfterTransactionCompletionProcess afterTransactionCompletionProcess : this.processes) {
                try {
                    afterTransactionCompletionProcess.doAfterTransactionCompletion(bl, this.session);
                }
                catch (CacheException cacheException) {
                    LOG.unableToReleaseCacheLock(cacheException);
                }
                catch (Exception exception) {
                    throw new AssertionFailure("Exception releasing cache locks", exception);
                }
            }
            this.processes.clear();
            if (this.session.getFactory().getSettings().isQueryCacheEnabled()) {
                this.session.getFactory().getUpdateTimestampsCache().invalidate((Serializable[])this.querySpacesToInvalidate.toArray(new String[this.querySpacesToInvalidate.size()]));
            }
            this.querySpacesToInvalidate.clear();
        }
    }

    private static class BeforeTransactionCompletionProcessQueue {
        private SessionImplementor session;
        private Queue<BeforeTransactionCompletionProcess> processes = new ConcurrentLinkedQueue<BeforeTransactionCompletionProcess>();

        private BeforeTransactionCompletionProcessQueue(SessionImplementor sessionImplementor) {
            this.session = sessionImplementor;
        }

        public void register(BeforeTransactionCompletionProcess beforeTransactionCompletionProcess) {
            if (beforeTransactionCompletionProcess == null) {
                return;
            }
            this.processes.add(beforeTransactionCompletionProcess);
        }

        public void beforeTransactionCompletion() {
            for (BeforeTransactionCompletionProcess beforeTransactionCompletionProcess : this.processes) {
                try {
                    beforeTransactionCompletionProcess.doBeforeTransactionCompletion(this.session);
                }
                catch (HibernateException hibernateException) {
                    throw hibernateException;
                }
                catch (Exception exception) {
                    throw new AssertionFailure("Unable to perform beforeTransactionCompletion callback", exception);
                }
            }
            this.processes.clear();
        }
    }
}

